/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.resttestcases.core.Context;
import io.github.resttestcases.core.NodePath;
import io.github.resttestcases.core.RestTestCasesException;
import io.github.resttestcases.core.Utils;
import io.github.resttestcases.core.config.RestTestCasesConfigTO;
import io.github.resttestcases.core.config.StatementConfigTO;
import io.github.resttestcases.core.statements.NodeStatement;
import io.github.resttestcases.core.statements.RootStatement;
import io.restassured.RestAssured;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Factory {
    protected static Logger logger = LoggerFactory.getLogger((String)"io.github.resttestcases");
    protected static Logger loggerHttp = LoggerFactory.getLogger((String)"io.github.resttestcases.HTTP");
    protected static List<StatementConfigTO> statementsConfig = new ArrayList<StatementConfigTO>();
    protected static String baseURI;
    private static ObjectMapper yamlMapper;
    private static boolean config;

    public static ObjectMapper getYamlMapper() {
        return yamlMapper;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Logger getLoggerHTTP() {
        return loggerHttp;
    }

    public static Context createContext() {
        return new Context();
    }

    private static void config() throws IOException {
        logger.info("Init Rest Test Cases Tool");
        yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        yamlMapper.findAndRegisterModules();
        logger.debug("Init Yaml Mapper");
        logger.debug("Reading config file:io/github/resttestcases/config.yaml");
        String configYaml = Utils.readTxtResource("io/github/resttestcases/config.yaml");
        RestTestCasesConfigTO confTO = (RestTestCasesConfigTO)yamlMapper.readValue(configYaml, RestTestCasesConfigTO.class);
        for (StatementConfigTO it : confTO.getStatements()) {
            statementsConfig.add(it);
            logger.debug("Add statement config:" + it.getClassName());
        }
        logger.debug("Reading config file:io/github/resttestcases/config.yaml");
        try {
            configYaml = Utils.readTxtResource("resttestcases.conf.yaml");
            confTO = (RestTestCasesConfigTO)yamlMapper.readValue(configYaml, RestTestCasesConfigTO.class);
        }
        catch (IOException e) {
            logger.error("Erro reading config file:io/github/resttestcases/config.yaml - " + e.getMessage(), (Throwable)e);
        }
        for (StatementConfigTO it : confTO.getStatements()) {
            statementsConfig.add(it);
            logger.debug("Add statement config:" + it.getClassName());
        }
        baseURI = confTO.getBaseURI();
        RestAssured.baseURI = confTO.getBaseURI();
        logger.debug("Add Base URI:" + baseURI);
        config = true;
    }

    public static RootStatement createRootStatament(String yamlText) throws IOException {
        if (!config) {
            Factory.config();
        }
        JsonNode node = yamlMapper.readTree(yamlText);
        return new RootStatement(node);
    }

    public static NodeStatement createStatement(NodePath path, NodeStatement parent) {
        StatementConfigTO typeNodeTester = Factory.createStatement(path, parent.getClass().getName());
        if (typeNodeTester == null) {
            throw new RestTestCasesException("Invalid declaration in " + path.toString());
        }
        try {
            return Factory.getInstance(typeNodeTester);
        }
        catch (ReflectiveOperationException e) {
            throw new RestTestCasesException("Invalid declaration in " + path.toString() + " - " + e.getMessage(), e);
        }
    }

    private static StatementConfigTO createStatement(NodePath path, String parentClass) {
        String name = path.getLast();
        for (StatementConfigTO it : statementsConfig) {
            if (!name.matches(it.getName())) continue;
            for (String parentExpected : it.getParents()) {
                if (!parentClass.equals(parentExpected)) continue;
                return it;
            }
        }
        return null;
    }

    private static NodeStatement getInstance(StatementConfigTO typeNodeTester) throws ReflectiveOperationException {
        Class<?> loadClass = Factory.class.getClassLoader().loadClass(typeNodeTester.getClassName());
        return (NodeStatement)loadClass.newInstance();
    }

    static {
        config = false;
    }
}

