/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.core;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.resttestcases.core.RestTestCasesException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.ComparisonFailure;

public class ValidateJson {
    public static void valide(JsonNode expected, JsonNode actual) {
        Error error = ValidateJson.validJson(new Path(), expected, actual);
        if (error != null) {
            String msg = "";
            if (error.expected == null) {
                msg = "not expected field " + error.actual;
            }
            throw new ComparisonFailure("Comparison failure in <" + error.path.toString() + "> " + msg, expected.toString(), actual.toString());
        }
    }

    private static Error validJson(Path path, JsonNode expected, JsonNode actual) {
        if (expected.isValueNode()) {
            return ValidateJson.validJsonPrimitive(new Path(), expected, actual);
        }
        if (expected.isObject()) {
            return ValidateJson.validJsonObject(new Path(), expected, actual);
        }
        if (expected.isArray()) {
            return ValidateJson.validJsonArray(new Path(), expected, actual);
        }
        return null;
    }

    private static Error validJsonPrimitive(Path path, JsonNode expected, JsonNode actual) {
        if ("?".equals(expected.textValue()) || "\\?".equals(expected.textValue()) && "?".equals(actual.textValue())) {
            return null;
        }
        if (actual != null && actual.isValueNode() && expected.equals((Object)actual)) {
            return null;
        }
        return new Error(path, expected, actual);
    }

    private static Error validJsonObject(Path path, JsonNode expected, JsonNode actual) {
        if (!actual.isObject()) {
            return new Error(path, expected, actual);
        }
        Iterator set = expected.fields();
        HashSet actualFields = new HashSet();
        actual.fieldNames().forEachRemaining(it -> actualFields.add(it));
        boolean acceptMoreFields = false;
        while (set.hasNext()) {
            Error ret;
            Map.Entry it2 = (Map.Entry)set.next();
            String key = (String)it2.getKey();
            JsonNode value = (JsonNode)it2.getValue();
            actualFields.remove(key);
            if ("...".equals(key) && "?".equals(value.textValue())) {
                acceptMoreFields = true;
                continue;
            }
            if (value.isNull() && actual.get(key) != null && !actual.get(key).isNull()) {
                return new Error(path.child(key), expected, actual.get(key));
            }
            if (value.isValueNode()) {
                ret = ValidateJson.validJsonPrimitive(path.child(key), value, actual.get(key));
                if (ret == null) continue;
                return ret;
            }
            if (value.isObject()) {
                ret = ValidateJson.validJsonObject(path.child(key), value, actual.get(key));
                if (ret == null) continue;
                return ret;
            }
            if (((JsonNode)it2.getValue()).isArray()) {
                ret = ValidateJson.validJsonArray(path.child(key), value, actual.get(key));
                if (ret == null) continue;
                return ret;
            }
            return new Error(path.child(key), expected, actual.get(key));
        }
        if (!acceptMoreFields && !actualFields.isEmpty()) {
            String fieldname = (String)actualFields.iterator().next();
            return new Error(path, fieldname + ":" + actual.get(fieldname).toString());
        }
        return null;
    }

    private static Error validJsonArray(Path path, JsonNode expectedElement, JsonNode actualElement) {
        JsonNode node;
        if (!actualElement.isArray()) {
            return new Error(path, expectedElement, actualElement);
        }
        ArrayList<JsonNode> expected = new ArrayList<JsonNode>();
        expectedElement.forEach(e -> expected.add((JsonNode)e));
        ArrayList<JsonNode> actual = new ArrayList<JsonNode>();
        actualElement.forEach(e -> actual.add((JsonNode)e));
        boolean inOrder = false;
        if (!expected.isEmpty() && (node = (JsonNode)expected.get(0)).isValueNode() && !node.isNull() && node.textValue().startsWith("!")) {
            String[] cmds;
            expected.remove(0);
            for (String cmd : cmds = node.textValue().substring(1).split(";")) {
                if ("inOrder".equals(cmd = cmd.trim())) {
                    inOrder = true;
                    continue;
                }
                if (cmd.matches("length:\\d+")) {
                    int expectedSize = Integer.parseInt(cmd.substring(7));
                    if (expectedSize == actual.size()) continue;
                    throw new ComparisonFailure("Comparison failure in <" + path + "> length", Integer.toString(expectedSize), Integer.toString(actual.size()));
                }
                throw new RestTestCasesException("Invalid statement in json expected <" + path.toString() + "> " + node.textValue());
            }
        }
        Error e2 = inOrder ? ValidateJson.validJsonArrayInOrder(path, expected, actual) : ValidateJson.validJsonArrayAnyOrder(path, expected, actual);
        return e2 == null ? null : new Error(path, expectedElement.toString(), actualElement.toString());
    }

    private static Error validJsonArrayAnyOrder(Path path, List<JsonNode> expected, List<JsonNode> actual) {
        boolean acceptAny = false;
        int i = 0;
        for (JsonNode it : expected) {
            if (it.isValueNode() && "...".equals(it.textValue())) {
                acceptAny = true;
                continue;
            }
            Error aux = ValidateJson.existeInArray(path.child("[" + i + "]"), it, actual);
            if (aux == null) continue;
            return new Error(path, expected, actual);
        }
        if (!acceptAny && !actual.isEmpty()) {
            return new Error(path, expected, actual);
        }
        return null;
    }

    private static Error validJsonArrayInOrder(Path path, List<JsonNode> expected, List<JsonNode> actual) {
        boolean acceptMore = false;
        int indexActual = 0;
        for (JsonNode it : expected) {
            if (it.isValueNode() && "...".equals(it.textValue())) {
                acceptMore = true;
                continue;
            }
            if (indexActual >= actual.size()) {
                return new Error(path, expected, actual);
            }
            Error aux = null;
            if (acceptMore) {
                while ((aux = ValidateJson.validJson(path.child("[" + indexActual + "]"), it, actual.get(indexActual))) != null && ++indexActual < actual.size()) {
                }
                acceptMore = false;
            } else {
                aux = ValidateJson.validJson(path.child("[" + indexActual + "]"), it, actual.get(indexActual));
                ++indexActual;
            }
            if (aux == null) continue;
            return new Error(path, expected, actual);
        }
        if (!acceptMore && indexActual < actual.size()) {
            return new Error(path, expected, actual);
        }
        return null;
    }

    private static Error existeInArray(Path path, JsonNode expected, List<JsonNode> list) {
        for (JsonNode it : list) {
            Error aux;
            if (expected.isValueNode()) {
                aux = ValidateJson.validJsonPrimitive(path, expected, it);
                if (aux != null) continue;
                list.remove(it);
                return null;
            }
            if (expected.isObject()) {
                aux = ValidateJson.validJsonObject(path, expected, it);
                if (aux != null) continue;
                list.remove(it);
                return null;
            }
            if (!expected.isArray() || (aux = ValidateJson.validJsonArray(path, expected, it)) != null) continue;
            list.remove(it);
            return null;
        }
        return new Error(path, expected, "in [...]");
    }

    private static class Path {
        private String[] path = new String[0];

        public Path child(String name) {
            Path newPath = new Path();
            newPath.path = Arrays.copyOf(this.path, this.path.length + 1);
            newPath.path[this.path.length] = name;
            return newPath;
        }

        public String toString() {
            return String.join((CharSequence)".", this.path);
        }
    }

    private static class Error {
        private Path path;
        private Object expected;
        private Object actual;

        public Error(Path path, Object expected, Object actual) {
            this.path = path;
            this.expected = expected;
            this.actual = actual;
        }

        public Error(Path path, Object actual) {
            this.path = path;
            this.actual = actual;
        }
    }
}

