/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.core.junit;

import io.github.resttestcases.core.Context;
import io.github.resttestcases.core.Factory;
import io.github.resttestcases.core.Utils;
import io.github.resttestcases.core.statements.NodeStatement;
import io.github.resttestcases.core.statements.RootStatement;
import io.github.resttestcases.statements.TestStatement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;

public class DynamicTestFactory {
    public static Iterable<? extends DynamicNode> createDynamicTestNodes(File dir, Properties properties) throws IOException {
        return DynamicTestFactory.createDynamicTestNodes(dir, properties, Factory.createContext());
    }

    private static Iterable<? extends DynamicNode> createDynamicTestNodes(File dir, Properties properties, Context context) throws IOException {
        ArrayList<DynamicContainer> nodes = new ArrayList<DynamicContainer>();
        for (File it : dir.listFiles()) {
            if (it.isDirectory()) {
                nodes.add(DynamicContainer.dynamicContainer((String)it.getName(), DynamicTestFactory.createDynamicTestNodes(it, properties, context)));
                continue;
            }
            if (!it.getName().endsWith(".yaml")) continue;
            RootStatement rootNode = Factory.createRootStatament(DynamicTestFactory.getFileWithParameters(it, properties));
            nodes.add(DynamicContainer.dynamicContainer((String)it.getName(), DynamicTestFactory.createTests(rootNode, properties, context)));
        }
        return nodes;
    }

    private static Iterable<? extends DynamicNode> createTests(RootStatement rootNode, Properties properties, Context context) {
        ArrayList<DynamicTest> nodes = new ArrayList<DynamicTest>();
        for (NodeStatement it : rootNode.getChildren()) {
            if (!(it instanceof TestStatement)) continue;
            TestStatement testNode = (TestStatement)it;
            nodes.add(DynamicTest.dynamicTest((String)testNode.getPath().getLast(), () -> testNode.execute(context)));
        }
        return nodes;
    }

    private static String getFileWithParameters(File file, Properties properties) throws IOException {
        String readTxtResource;
        try {
            readTxtResource = Utils.readTxtResource(file);
        }
        catch (Exception e) {
            throw new IOException("Error reading file " + file.getAbsolutePath(), e);
        }
        List<String> parameters = DynamicTestFactory.getParameters(readTxtResource);
        for (String par : parameters) {
            readTxtResource = readTxtResource.replace("${" + par + "}", properties.getProperty(par));
        }
        return readTxtResource;
    }

    private static List<String> getParameters(String jsonTxt) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(jsonTxt);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }
}

