/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.core.statements;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.resttestcases.core.Context;
import io.github.resttestcases.core.Factory;
import io.github.resttestcases.core.NodePath;
import io.github.resttestcases.core.RestTestCasesException;
import io.github.resttestcases.core.statements.LeafNodeStatement;
import io.github.resttestcases.core.statements.NodeStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ParentNodeStatement
extends LeafNodeStatement {
    protected List<NodeStatement> statements = new ArrayList<NodeStatement>();

    @Override
    public void valide(NodePath path, JsonNode node) {
        if (!node.isObject()) {
            throw new RestTestCasesException("Invalid statement in " + path.toString());
        }
    }

    @Override
    public void config(NodePath pathInit, NodeStatement parentInit, JsonNode node) {
        super.config(pathInit, parentInit, node);
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String itName = (String)fieldNames.next();
            NodePath itPath = this.path.expand(itName);
            NodeStatement it = Factory.createStatement(itPath, this);
            if (it == null) {
                throw new RestTestCasesException("Invalid statement in " + this.path.toString());
            }
            it.config(itPath, this, node.get(itName));
            this.statements.add(it);
        }
    }

    @Override
    public void execute(Context context) {
        for (NodeStatement statement : this.statements) {
            statement.execute(context);
        }
    }

    protected <T> T removeStatement(Class<T> statementClass) {
        T statement = this.findStatement(statementClass);
        if (statement != null) {
            this.statements.remove(statement);
        }
        return statement;
    }

    protected <T> T findStatement(Class<T> statementClass) {
        for (NodeStatement it : this.statements) {
            if (!it.getClass().equals(statementClass)) continue;
            return (T)it;
        }
        return null;
    }

    public List<NodeStatement> getChildren() {
        return this.statements;
    }
}

