/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.statements.request;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.resttestcases.core.Context;
import io.github.resttestcases.core.NodePath;
import io.github.resttestcases.core.Utils;
import io.github.resttestcases.core.statements.LeafNodeStatement;
import io.github.resttestcases.core.statements.NodeStatement;
import io.restassured.internal.util.IOUtils;
import io.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class RequestMultiPartFilesStatement
extends LeafNodeStatement {
    private Map<String, String> params;

    @Override
    public void config(NodePath path, NodeStatement parent, JsonNode node) {
        super.config(path, parent, node);
        this.params = Utils.toMapKeyTextValue(path, node);
    }

    @Override
    public void execute(Context context) {
        RequestSpecification req = (RequestSpecification)context.getParam(RequestSpecification.class.getName());
        for (Map.Entry<String, String> it : this.params.entrySet()) {
            try {
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(it.getValue());
                assert (in != null) : "Resource not found: " + it.getValue() + ".";
                req.multiPart(it.getKey(), it.getValue(), IOUtils.toByteArray((InputStream)in));
            }
            catch (IOException e) {
                throw new AssertionError((Object)("Error reading resource: " + it.getValue() + "." + e.getMessage()));
            }
        }
    }
}

