/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.statements.request;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.resttestcases.core.Context;
import io.github.resttestcases.core.NodePath;
import io.github.resttestcases.core.RestTestCasesException;
import io.github.resttestcases.core.statements.NodeStatement;
import io.github.resttestcases.core.statements.ParentNodeStatement;
import io.github.resttestcases.statements.request.RequestMethodPathStatement;
import io.github.resttestcases.statements.response.ResponseStatement;
import io.restassured.RestAssured;
import io.restassured.http.Method;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;

public class RequestStatement
extends ParentNodeStatement {
    protected Method httpMethodReq;
    private String uri;
    private ResponseStatement responseStatement;

    @Override
    public void config(NodePath path, NodeStatement parent, JsonNode node) {
        RequestMethodPathStatement requestMethodPath;
        if (node.isObject()) {
            super.config(path, parent, node);
            requestMethodPath = this.removeStatement(RequestMethodPathStatement.class);
            if (requestMethodPath == null || this.httpMethodReq == null) {
                throw new RestTestCasesException("Invalid statement in " + path.toString() + "! Not found METHOD: path ");
            }
        } else {
            throw new RestTestCasesException("Invalid statement in " + path.toString());
        }
        this.uri = requestMethodPath.getValue();
        this.responseStatement = this.removeStatement(ResponseStatement.class);
    }

    @Override
    public void execute(Context context) {
        logger.debug("Executing request {} {}", (Object)this.httpMethodReq, (Object)this.uri);
        RequestSpecification req = RestAssured.given();
        context.setParam(RequestSpecification.class.getName(), req);
        super.execute(context);
        context.setParam(Response.class.getName(), this.executeRequest(req));
        context.removeParam(RequestSpecification.class.getName());
        context.logRequest();
        context.logResponse();
        if (this.responseStatement != null) {
            this.responseStatement.execute(context);
        }
        context.removeParam(Response.class.getName());
    }

    private Response executeRequest(RequestSpecification reqSpec) {
        switch (this.httpMethodReq) {
            case GET: {
                return (Response)reqSpec.get(this.uri, new Object[0]);
            }
            case POST: {
                return (Response)reqSpec.post(this.uri, new Object[0]);
            }
            case PUT: {
                return (Response)reqSpec.put(this.uri, new Object[0]);
            }
            case DELETE: {
                return (Response)reqSpec.delete(this.uri, new Object[0]);
            }
        }
        throw new AssertionError((Object)("Request Method " + this.httpMethodReq + " invalid in " + this.path.toString()));
    }
}

