/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.statements.response;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.resttestcases.core.Context;
import io.github.resttestcases.core.NodePath;
import io.github.resttestcases.core.RestTestCasesException;
import io.github.resttestcases.core.ValidateJson;
import io.github.resttestcases.core.statements.LeafNodeStatement;
import io.github.resttestcases.core.statements.NodeStatement;
import io.restassured.response.Response;
import java.io.IOException;

public class ResponseBodyJsonStatement
extends LeafNodeStatement {
    private String expected;

    @Override
    public void config(NodePath pathInit, NodeStatement parentInit, JsonNode node) {
        super.config(pathInit, parentInit, node);
        this.expected = node.asText();
        if (this.expected == null) {
            this.expected = node.toString();
        }
    }

    @Override
    public void execute(Context context) {
        logger.debug("Valid response {}", (Object)this.path.getLast());
        Response response = (Response)context.getParam(Response.class.getName());
        String actual = response.getBody().asString();
        try {
            ValidateJson.valide(context.toJsonNode(this.expected), context.toJsonNode(actual));
        }
        catch (IOException e) {
            throw new RestTestCasesException("Erro in " + this.path + " message:" + e.getMessage(), e);
        }
    }
}

