/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.statements.response;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.resttestcases.core.Context;
import io.github.resttestcases.core.NodePath;
import io.github.resttestcases.core.Utils;
import io.github.resttestcases.core.statements.LeafNodeStatement;
import io.github.resttestcases.core.statements.NodeStatement;
import io.restassured.response.ValidatableResponse;
import java.util.Map;

public class ResponseHeadersStatement
extends LeafNodeStatement {
    private Map<String, String> params;

    @Override
    public void config(NodePath path, NodeStatement parent, JsonNode node) {
        super.config(path, parent, node);
        this.params = Utils.toMapKeyTextValue(path, node);
    }

    @Override
    public void execute(Context context) {
        logger.debug("Valid response headers");
        ValidatableResponse validate = (ValidatableResponse)context.getParam(ValidatableResponse.class.getName());
        for (Map.Entry<String, String> it : this.params.entrySet()) {
            logger.debug("Valid response header {}", (Object)it.getKey());
            validate.header(it.getKey(), it.getValue());
        }
    }
}

