/*
 * Decompiled with CFR 0.152.
 */
package io.github.resttestcases.statements.response;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.resttestcases.core.Context;
import io.github.resttestcases.core.NodePath;
import io.github.resttestcases.core.RestTestCasesException;
import io.github.resttestcases.core.statements.LeafNodeStatement;
import io.github.resttestcases.core.statements.NodeStatement;
import io.restassured.response.ValidatableResponse;

public class ResponseStatusStatement
extends LeafNodeStatement {
    private int status;

    @Override
    public void valide(NodePath path, JsonNode node) {
        if (!node.isInt()) {
            throw new RestTestCasesException("Invalid statement in " + path.toString() + ". Request status expects an integer number.");
        }
    }

    @Override
    public void config(NodePath pathInit, NodeStatement parentInit, JsonNode node) {
        super.config(pathInit, parentInit, node);
        this.status = node.asInt();
    }

    @Override
    public void execute(Context context) {
        logger.debug("Valid response status code {}", (Object)this.status);
        ValidatableResponse response = (ValidatableResponse)context.getParam(ValidatableResponse.class.getName());
        response.statusCode(this.status);
    }
}

