/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import robaho.net.httpserver.ExchangeImpl;
import robaho.net.httpserver.ServerConfig;
import robaho.net.httpserver.ServerImpl;

abstract class LeftOverInputStream
extends FilterInputStream {
    final ExchangeImpl t;
    final ServerImpl server;
    protected boolean closed = false;
    protected boolean eof = false;
    byte[] one = new byte[1];

    public LeftOverInputStream(ExchangeImpl t, InputStream src) {
        super(src);
        this.t = t;
        this.server = t.getServerImpl();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.eof) {
            this.eof = this.drain(ServerConfig.getDrainAmount());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected abstract int readImpl(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int c = this.readImpl(this.one, 0, 1);
        if (c == -1 || c == 0) {
            return c;
        }
        return this.one[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        return this.readImpl(b, off, len);
    }

    public boolean drain(long l) throws IOException {
        int bufSize = 2048;
        byte[] db = new byte[bufSize];
        while (l > 0L && !this.server.isFinishing()) {
            long len = this.readImpl(db, 0, bufSize);
            if (len == -1L) {
                this.eof = true;
                return true;
            }
            l -= len;
        }
        return false;
    }
}

