/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.websockets;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import robaho.net.httpserver.websockets.CloseCode;
import robaho.net.httpserver.websockets.CloseFrame;
import robaho.net.httpserver.websockets.OpCode;
import robaho.net.httpserver.websockets.State;
import robaho.net.httpserver.websockets.WebSocketException;
import robaho.net.httpserver.websockets.WebSocketFrame;

public abstract class WebSocket {
    Logger logger = Logger.getLogger(WebSocket.class.getName());
    private final InputStream in;
    private final OutputStream out;
    private OpCode continuousOpCode = null;
    private final List<WebSocketFrame> continuousFrames = new LinkedList<WebSocketFrame>();
    private State state = State.UNCONNECTED;
    private Lock lock = new ReentrantLock();

    protected WebSocket(HttpExchange exchange) {
        this.state = State.CONNECTING;
        this.in = exchange.getRequestBody();
        this.out = exchange.getResponseBody();
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    protected void onOpen() throws WebSocketException {
    }

    protected abstract void onClose(CloseCode var1, String var2, boolean var3);

    protected abstract void onMessage(WebSocketFrame var1) throws WebSocketException;

    protected abstract void onPong(WebSocketFrame var1) throws WebSocketException;

    protected void onException(IOException exception) {
        this.logger.log(Level.FINER, "exception on websocket", exception);
    }

    protected void onFrameReceived(WebSocketFrame frame) {
        this.logger.log(Level.FINER, () -> "frame received: " + String.valueOf(frame));
    }

    protected void onFrameSent(WebSocketFrame frame) {
        this.logger.log(Level.FINER, () -> "frame sent: " + String.valueOf(frame));
    }

    public void close(CloseCode code, String reason, boolean initiatedByRemote) throws IOException {
        State oldState = this.state;
        this.state = State.CLOSING;
        if (oldState == State.OPEN) {
            this.sendFrame(new CloseFrame(code, reason));
        } else {
            this.doClose(code, reason, initiatedByRemote);
        }
    }

    void doClose(CloseCode code, String reason, boolean initiatedByRemote) {
        if (this.state == State.CLOSED) {
            return;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, "close failed", e);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, "close failed", e);
            }
        }
        this.state = State.CLOSED;
        this.onClose(code, reason, initiatedByRemote);
    }

    private void handleCloseFrame(WebSocketFrame frame) throws IOException {
        CloseCode code = CloseCode.NormalClosure;
        String reason = "";
        if (frame instanceof CloseFrame) {
            code = ((CloseFrame)frame).getCloseCode();
            reason = ((CloseFrame)frame).getCloseReason();
        }
        if (this.state == State.CLOSING) {
            this.doClose(code, reason, false);
        } else {
            this.close(code, reason, true);
        }
    }

    private void handleFrameFragment(WebSocketFrame frame) throws IOException {
        if (frame.getOpCode() != OpCode.Continuation) {
            if (this.continuousOpCode != null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Previous continuous frame sequence not completed.");
            }
            this.continuousOpCode = frame.getOpCode();
            this.continuousFrames.clear();
            this.continuousFrames.add(frame);
        } else if (frame.isFin()) {
            if (this.continuousOpCode == null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Continuous frame sequence was not started.");
            }
            this.continuousFrames.add(frame);
            this.onMessage(new WebSocketFrame(this.continuousOpCode, this.continuousFrames));
            this.continuousOpCode = null;
            this.continuousFrames.clear();
        } else {
            if (this.continuousOpCode == null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Continuous frame sequence was not started.");
            }
            this.continuousFrames.add(frame);
        }
    }

    private void handleWebsocketFrame(WebSocketFrame frame) throws IOException {
        this.onFrameReceived(frame);
        if (frame.getOpCode() == OpCode.Close) {
            this.handleCloseFrame(frame);
        } else if (frame.getOpCode() == OpCode.Ping) {
            this.sendFrame(new WebSocketFrame(OpCode.Pong, true, frame.getBinaryPayload()));
        } else if (frame.getOpCode() == OpCode.Pong) {
            this.onPong(frame);
        } else if (!frame.isFin() || frame.getOpCode() == OpCode.Continuation) {
            this.handleFrameFragment(frame);
        } else {
            if (this.continuousOpCode != null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Continuous frame sequence not completed.");
            }
            if (frame.getOpCode() == OpCode.Text || frame.getOpCode() == OpCode.Binary) {
                this.onMessage(frame);
            } else {
                throw new WebSocketException(CloseCode.ProtocolError, "Non control or continuous frame expected.");
            }
        }
    }

    public void ping(byte[] payload) throws IOException {
        this.sendFrame(new WebSocketFrame(OpCode.Ping, true, payload));
    }

    void readWebsocket() {
        try {
            this.state = State.OPEN;
            this.onOpen();
            while (this.state == State.OPEN) {
                this.handleWebsocketFrame(WebSocketFrame.read(this.in));
            }
        }
        catch (CharacterCodingException e) {
            this.onException(e);
            this.doClose(CloseCode.InvalidFramePayloadData, e.toString(), false);
        }
        catch (IOException e) {
            this.onException(e);
            if (e instanceof WebSocketException) {
                WebSocketException wse = (WebSocketException)e;
                this.doClose(wse.getCode(), wse.getReason(), false);
            }
        }
        finally {
            this.doClose(CloseCode.InternalServerError, "Handler terminated without closing the connection.", false);
            this.logger.info("readWebsocket() exiting");
        }
    }

    public void send(byte[] payload) throws IOException {
        this.sendFrame(new WebSocketFrame(OpCode.Binary, true, payload));
    }

    public void send(String payload) throws IOException {
        this.sendFrame(new WebSocketFrame(OpCode.Text, true, payload));
    }

    public void sendFrame(WebSocketFrame frame) throws IOException {
        this.lock.lock();
        try {
            this.onFrameSent(frame);
            frame.write(this.out);
        }
        finally {
            this.lock.unlock();
        }
    }
}

