/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2;

import com.sun.net.httpserver.Headers;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import robaho.net.httpserver.HttpConnection;
import robaho.net.httpserver.ServerConfig;
import robaho.net.httpserver.http2.HTTP2ErrorCode;
import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.HTTP2Stream;
import robaho.net.httpserver.http2.Utils;
import robaho.net.httpserver.http2.frame.BaseFrame;
import robaho.net.httpserver.http2.frame.ContinuationFrame;
import robaho.net.httpserver.http2.frame.DataFrame;
import robaho.net.httpserver.http2.frame.FrameFlag;
import robaho.net.httpserver.http2.frame.FrameHeader;
import robaho.net.httpserver.http2.frame.FrameSerializer;
import robaho.net.httpserver.http2.frame.FrameType;
import robaho.net.httpserver.http2.frame.GoawayFrame;
import robaho.net.httpserver.http2.frame.HeadersFrame;
import robaho.net.httpserver.http2.frame.PingFrame;
import robaho.net.httpserver.http2.frame.ResetStreamFrame;
import robaho.net.httpserver.http2.frame.SettingIdentifier;
import robaho.net.httpserver.http2.frame.SettingParameter;
import robaho.net.httpserver.http2.frame.SettingsFrame;
import robaho.net.httpserver.http2.frame.WindowUpdateFrame;
import robaho.net.httpserver.http2.hpack.HPackContext;
import robaho.net.httpserver.http2.hpack.HTTP2HeaderField;
import robaho.net.httpserver.http2.hpack.HeaderFields;

public class HTTP2Connection {
    static final String PREFACE = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n";
    static final String PARTIAL_PREFACE = "\r\nSM\r\n\r\n";
    private final InputStream inputStream;
    final OutputStream outputStream;
    private int lastSeenStreamId = 0;
    final ConcurrentMap<Integer, HTTP2Stream> http2Streams = new ConcurrentHashMap<Integer, HTTP2Stream>();
    private final Set<Integer> previousStreams = new HashSet<Integer>();
    private final HashMap<SettingIdentifier, SettingParameter> remoteSettings = new HashMap();
    private final HashMap<SettingIdentifier, SettingParameter> localSettings = new HashMap();
    private final StreamHandler handler;
    private final Lock lock = new ReentrantLock();
    final HttpConnection httpConnection;
    final System.Logger logger;
    final HPackContext hpack = new HPackContext();
    final AtomicLong sendWindow = new AtomicLong(65535L);
    final AtomicInteger receiveWindow = new AtomicInteger(65535);
    private int maxConcurrentStreams = -1;
    private int highNumberStreams = 0;

    public HTTP2Connection(HttpConnection httpConnection, InputStream input, OutputStream output, StreamHandler handler) {
        this.httpConnection = httpConnection;
        this.inputStream = input;
        this.outputStream = output;
        this.handler = handler;
        this.logger = System.getLogger("robaho.net.httpserver.http2");
        this.localSettings.put(SettingIdentifier.SETTINGS_MAX_FRAME_SIZE, new SettingParameter(SettingIdentifier.SETTINGS_MAX_FRAME_SIZE, ServerConfig.http2MaxFrameSize()));
        this.localSettings.put(SettingIdentifier.SETTINGS_INITIAL_WINDOW_SIZE, new SettingParameter(SettingIdentifier.SETTINGS_INITIAL_WINDOW_SIZE, ServerConfig.http2InitialWindowSize()));
        if (ServerConfig.http2MaxConcurrentStreams() != -1) {
            this.localSettings.put(SettingIdentifier.SETTINGS_MAX_CONCURRENT_STREAMS, new SettingParameter(SettingIdentifier.SETTINGS_MAX_CONCURRENT_STREAMS, ServerConfig.http2MaxConcurrentStreams()));
        }
        this.logger.log(System.Logger.Level.DEBUG, "opened http2 connection " + String.valueOf(httpConnection) + ", max concurrent streams " + ServerConfig.http2MaxConcurrentStreams());
    }

    public String toString() {
        return "{" + String.valueOf(this.httpConnection) + ", streams=" + this.http2Streams.size() + ", high " + this.highNumberStreams + "}";
    }

    public void close() {
        for (HTTP2Stream stream : this.http2Streams.values()) {
            stream.close();
        }
    }

    public HashMap<SettingIdentifier, SettingParameter> getRemoteSettings() {
        return this.remoteSettings;
    }

    public HashMap<SettingIdentifier, SettingParameter> getLocalSettings() {
        return this.localSettings;
    }

    public boolean hasProperPreface() throws IOException {
        String preface_match = this.httpConnection.isSSL() ? PREFACE : PARTIAL_PREFACE;
        byte[] preface = new byte[preface_match.length()];
        this.inputStream.read(preface);
        String prefaceStr = new String(preface, 0, preface.length);
        return prefaceStr.equals(preface_match);
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    public boolean isClosed() {
        return this.httpConnection.isClosed();
    }

    public void handle() throws Exception {
        try {
            this.processFrames();
        }
        catch (HTTP2Exception e) {
            this.logger.log(System.Logger.Level.DEBUG, "exception on http2 connection", (Throwable)e);
            this.sendGoAway(e.getErrorCode());
            throw e;
        }
    }

    private void processFrames() throws Exception {
        boolean inHeaders = false;
        int openStreamId = 0;
        ArrayList<byte[]> headerBlockFragments = new ArrayList<byte[]>();
        block12: while (!this.httpConnection.isClosed()) {
            BaseFrame frame = FrameSerializer.deserialize(this.inputStream);
            int streamId = frame.getHeader().getStreamIdentifier();
            if (streamId != 0 && streamId % 2 == 0) {
                throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "invalid stream id " + streamId + " on type " + String.valueOf((Object)frame.getHeader().getType()));
            }
            switch (frame.getHeader().getType()) {
                case SETTINGS: {
                    if (frame.getHeader().getFlags().contains((Object)FrameFlag.ACK)) {
                        if (ServerConfig.http2MaxConcurrentStreams() == -1) continue block12;
                        this.maxConcurrentStreams = this.http2Streams.size() + ServerConfig.http2MaxConcurrentStreams();
                        continue block12;
                    }
                    this.updateRemoteSettings((SettingsFrame)frame);
                    this.sendSettingsAck();
                    continue block12;
                }
                case GOAWAY: {
                    GoawayFrame goaway = (GoawayFrame)frame;
                    if (goaway.errorCode == HTTP2ErrorCode.NO_ERROR) continue block12;
                    throw new IOException("received GOAWAY from remote " + String.valueOf((Object)goaway.errorCode));
                }
                case PING: {
                    if (frame.getHeader().getFlags().contains((Object)FrameFlag.ACK)) continue block12;
                    this.sendPingAck((PingFrame)frame);
                    continue block12;
                }
                case WINDOW_UPDATE: {
                    if (frame.getHeader().getStreamIdentifier() != 0) break;
                    int windowSizeIncrement = ((WindowUpdateFrame)frame).getWindowSizeIncrement();
                    this.sendWindow.addAndGet(windowSizeIncrement);
                    this.logger.log(System.Logger.Level.DEBUG, "received connection window update " + windowSizeIncrement + ", new size " + this.sendWindow.get());
                    if (this.sendWindow.get() <= Integer.MAX_VALUE) continue block12;
                    throw new HTTP2Exception(HTTP2ErrorCode.FLOW_CONTROL_ERROR, "maximum window size exceeded");
                }
                case NOT_IMPLEMENTED: {
                    if (inHeaders) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "NOT_IMPLEMENTED frame received while headers being received");
                    }
                    if (frame.getHeader().getStreamIdentifier() != 0) break;
                    continue block12;
                }
                case DATA: {
                    DataFrame dataFrame = (DataFrame)frame;
                    if (this.receiveWindow.addAndGet(-dataFrame.body.length) <= 0) {
                        this.sendWindowUpdate();
                    }
                    if (!inHeaders) break;
                    throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "DATA frame received while headers being received");
                }
                case HEADERS: {
                    if (inHeaders) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "HEADERS frame received on open stream");
                    }
                    if (streamId < this.lastSeenStreamId) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "HEADERS frame received out of order");
                    }
                    HTTP2Stream stream = (HTTP2Stream)this.http2Streams.get(streamId);
                    if (stream != null) {
                        if (!stream.isOpen() || stream.isHalfClosed()) {
                            throw new HTTP2Exception(HTTP2ErrorCode.STREAM_CLOSED, "HEADERS frame received on already closed stream");
                        }
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "HEADERS frame received on already established stream");
                    }
                    HeadersFrame headersFrame = (HeadersFrame)frame;
                    headerBlockFragments.add(headersFrame.getHeaderBlock());
                    if (headersFrame.getHeader().getFlags().contains((Object)FrameFlag.END_HEADERS)) break;
                    inHeaders = true;
                    openStreamId = streamId;
                    continue block12;
                }
                case CONTINUATION: {
                    if (inHeaders && frame.getHeader().getStreamIdentifier() != openStreamId) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "HEADERS frame received on open stream");
                    }
                    if (!inHeaders) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "CONTINUATION frame received on closed stream");
                    }
                    ContinuationFrame continuationFrame = (ContinuationFrame)frame;
                    headerBlockFragments.add(continuationFrame.getHeaderBlock());
                    if (continuationFrame.getHeader().getFlags().contains((Object)FrameFlag.END_HEADERS)) break;
                    continue block12;
                }
                case PRIORITY: {
                    if (inHeaders) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "PRIORITY frame received during headers receive");
                    }
                    if (streamId != 0) continue block12;
                    throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "PRIORITY frame received on stream 0");
                }
                case RST_STREAM: {
                    ResetStreamFrame resetFrame = (ResetStreamFrame)frame;
                    if (resetFrame.errorCode == HTTP2ErrorCode.NO_ERROR) continue block12;
                    if (this.http2Streams.containsKey(streamId)) break;
                    if (this.previousStreams.contains(streamId)) continue block12;
                    throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "RST_STREAM frame received on non-existent stream");
                }
            }
            HTTP2Stream targetStream = null;
            if (this.http2Streams.containsKey(streamId)) {
                targetStream = (HTTP2Stream)this.http2Streams.get(streamId);
            } else if (this.lastSeenStreamId < streamId) {
                int currentSize = this.http2Streams.size();
                if (this.maxConcurrentStreams != -1 && currentSize >= this.maxConcurrentStreams) {
                    throw new HTTP2Exception(HTTP2ErrorCode.REFUSED_STREAM);
                }
                this.highNumberStreams = Math.max(this.highNumberStreams, currentSize);
                byte[] headerBlock = Utils.combineByteArrays(headerBlockFragments);
                HeaderFields fields = new HeaderFields();
                fields.addAll(this.hpack.decodeFieldSegments(headerBlock));
                fields.validate();
                Headers requestHeaders = new Headers();
                for (HTTP2HeaderField field : fields) {
                    if (field.value == null) {
                        this.logger.log(System.Logger.Level.TRACE, () -> "ignoring null header for " + field.getName());
                        continue;
                    }
                    requestHeaders.add(field.name, field.value);
                }
                headerBlockFragments.clear();
                inHeaders = false;
                targetStream = new HTTP2Stream(streamId, this, requestHeaders, this.handler);
                this.http2Streams.put(streamId, targetStream);
                this.previousStreams.add(streamId);
                this.lastSeenStreamId = streamId;
            } else {
                if (this.previousStreams.contains(streamId)) {
                    throw new HTTP2Exception(HTTP2ErrorCode.STREAM_CLOSED, "stream " + streamId + " is closed");
                }
                throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "Stream ID not in order");
            }
            if (targetStream == null) continue;
            targetStream.processFrame(frame);
        }
    }

    public void updateRemoteSettings(SettingsFrame remoteSettingFrame) throws HTTP2Exception {
        for (SettingParameter parameter : remoteSettingFrame.getSettingParameters()) {
            if (parameter.identifier == SettingIdentifier.SETTINGS_INITIAL_WINDOW_SIZE) {
                if (parameter.value > Integer.MAX_VALUE) {
                    throw new HTTP2Exception(HTTP2ErrorCode.FLOW_CONTROL_ERROR, "Invalid value for SETTINGS_INITIAL_WINDOW_SIZE " + parameter.value);
                }
                this.logger.log(System.Logger.Level.DEBUG, () -> "received initial window size of " + parameter.value);
            }
            if (parameter.identifier == SettingIdentifier.SETTINGS_MAX_FRAME_SIZE) {
                this.logger.log(System.Logger.Level.DEBUG, () -> "received max frame size " + parameter.value);
            }
            this.getRemoteSettings().put(parameter.identifier, parameter);
        }
    }

    public void sendSettingsAck() throws IOException {
        this.lock();
        try {
            SettingsFrame frame = new SettingsFrame();
            frame.writeTo(this.outputStream);
            this.outputStream.flush();
        }
        finally {
            this.unlock();
            this.logger.log(System.Logger.Level.TRACE, () -> "Sent Settings Ack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMySettings() throws IOException {
        this.lock();
        try {
            FrameHeader header = new FrameHeader(0, FrameType.SETTINGS, EnumSet.noneOf(FrameFlag.class), 0);
            SettingsFrame frame = new SettingsFrame(header);
            for (SettingParameter setting : this.localSettings.values()) {
                frame.getSettingParameters().add(setting);
            }
            frame.writeTo(this.outputStream);
            this.outputStream.flush();
        }
        finally {
            this.unlock();
            this.logger.log(System.Logger.Level.TRACE, () -> "Sent My Settings");
        }
    }

    public void sendWindowUpdate() throws IOException {
        this.lock();
        try {
            this.receiveWindow.addAndGet(65535);
            FrameHeader header = new FrameHeader(4, FrameType.WINDOW_UPDATE, EnumSet.noneOf(FrameFlag.class), 0);
            WindowUpdateFrame frame = new WindowUpdateFrame(header);
            frame.writeTo(this.outputStream);
            Utils.writeBinary(this.outputStream, 65535, 4);
            this.outputStream.flush();
        }
        finally {
            this.unlock();
            this.logger.log(System.Logger.Level.TRACE, () -> "Sent My Settings");
        }
    }

    InetSocketAddress getRemoteAddress() {
        return this.httpConnection.getRemoteAddress();
    }

    InetSocketAddress getLocalAddress() {
        return this.httpConnection.getLocalAddress();
    }

    public void sendGoAway(HTTP2ErrorCode errorCode) throws IOException {
        FrameHeader header = new FrameHeader(8, FrameType.GOAWAY, EnumSet.noneOf(FrameFlag.class), 0);
        this.lock();
        try {
            header.writeTo(this.outputStream);
            Utils.writeBinary(this.outputStream, this.lastSeenStreamId, 4);
            Utils.writeBinary(this.outputStream, errorCode.value, 4);
            this.outputStream.flush();
        }
        finally {
            this.unlock();
            this.logger.log(System.Logger.Level.TRACE, () -> "Sent GoAway " + String.valueOf((Object)errorCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResetStream(HTTP2ErrorCode errorCode, int streamId) throws IOException {
        FrameHeader header = new FrameHeader(4, FrameType.RST_STREAM, EnumSet.noneOf(FrameFlag.class), streamId);
        this.lock();
        try {
            header.writeTo(this.outputStream);
            Utils.writeBinary(this.outputStream, errorCode.value, 4);
            this.outputStream.flush();
        }
        finally {
            this.unlock();
            this.logger.log(System.Logger.Level.TRACE, () -> "Sent Reset Stream " + streamId);
        }
    }

    public void sendPing() throws IOException {
        FrameHeader header = new FrameHeader(8, FrameType.PING, EnumSet.noneOf(FrameFlag.class), 0);
        this.lock();
        try {
            header.writeTo(this.outputStream);
            Utils.writeBinary(this.outputStream, 0, 4);
            Utils.writeBinary(this.outputStream, 0, 4);
            this.outputStream.flush();
        }
        finally {
            this.unlock();
            this.logger.log(System.Logger.Level.TRACE, "Sent Ping");
        }
    }

    private void sendPingAck(PingFrame frame) throws IOException {
        this.lock();
        try {
            FrameHeader header = new FrameHeader(frame.body.length, FrameType.PING, EnumSet.of(FrameFlag.ACK), 0);
            header.writeTo(this.outputStream);
            this.outputStream.write(frame.body);
            this.outputStream.flush();
        }
        finally {
            this.unlock();
            this.logger.log(System.Logger.Level.TRACE, "Sent Ping Ack");
        }
    }

    public static void readFully(InputStream inputStream, byte[] buffer) throws IOException {
        if (buffer.length == 0) {
            return;
        }
        int bytesRead = 0;
        int offset = 0;
        int length = buffer.length;
        while (bytesRead != -1 && offset < length) {
            bytesRead = inputStream.read(buffer, offset, length - offset);
            if (bytesRead == -1) continue;
            offset += bytesRead;
        }
        if (offset == 0) {
            throw new EOFException("end of stream detected");
        }
        if (offset < length) {
            throw new IOException("failed to read the full buffer");
        }
    }

    public static interface StreamHandler {
        public void handleStream(HTTP2Stream var1, InputStream var2, OutputStream var3) throws IOException;

        public Executor getExecutor();
    }
}

