/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.frame;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import robaho.net.httpserver.http2.Utils;
import robaho.net.httpserver.http2.frame.FrameFlag;
import robaho.net.httpserver.http2.frame.FrameType;

public class FrameHeader {
    private final int length;
    private final FrameType type;
    private final EnumSet<FrameFlag> flags;
    private final int streamIdentifier;

    public int getLength() {
        return this.length;
    }

    public FrameType getType() {
        return this.type;
    }

    public EnumSet<FrameFlag> getFlags() {
        return this.flags;
    }

    public int getStreamIdentifier() {
        return this.streamIdentifier;
    }

    public FrameHeader(int length, FrameType type, EnumSet<FrameFlag> flags, int streamIdentifier) {
        this.length = length;
        this.type = type;
        this.flags = flags;
        this.streamIdentifier = streamIdentifier;
    }

    public String toString() {
        return "FrameHeader{length=" + this.length + ", type=" + String.valueOf((Object)this.type) + ", flags=" + String.valueOf(this.flags) + ", streamIdentifier=" + this.streamIdentifier + "}";
    }

    public static FrameHeader Parse(byte[] tmpBuffer) throws Exception {
        FrameHeader frameHeader = null;
        FrameType type = null;
        EnumSet<FrameFlag> flag = null;
        int streamIdentifier = 0;
        int length = 0;
        int readIndex = 0;
        length = Utils.convertToInt(tmpBuffer, readIndex, 3);
        type = FrameType.getEnum(tmpBuffer[readIndex += 3]);
        flag = FrameFlag.getEnumSet(tmpBuffer[++readIndex], type);
        streamIdentifier = Utils.convertToInt(tmpBuffer, ++readIndex);
        readIndex += 4;
        frameHeader = new FrameHeader(length, type, flag, streamIdentifier &= Integer.MAX_VALUE);
        return frameHeader;
    }

    public void writeTo(OutputStream os) throws IOException {
        Utils.writeBinary(os, this.length, 3);
        os.write(this.getType().value & 0xFF);
        os.write(FrameFlag.getValue(this.getFlags()) & 0xFF);
        Utils.writeBinary(os, this.streamIdentifier);
    }
}

