/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.frame;

public enum SettingIdentifier {
    SETTINGS_HEADER_TABLE_SIZE(1),
    SETTINGS_ENABLE_PUSH(2),
    SETTINGS_MAX_CONCURRENT_STREAMS(3),
    SETTINGS_INITIAL_WINDOW_SIZE(4),
    SETTINGS_MAX_FRAME_SIZE(5),
    SETTINGS_MAX_HEADER_LIST_SIZE(6),
    SETTINGS_NONE(0);

    int value;

    private SettingIdentifier(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SettingIdentifier getEnum(int value) {
        SettingIdentifier result = SETTINGS_NONE;
        for (SettingIdentifier e : SettingIdentifier.values()) {
            if (e.getValue() != value) continue;
            result = e;
        }
        return result;
    }

    public boolean validateValue(long value) {
        switch (this.ordinal()) {
            case 0: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return value >= 16384L && value <= 0xFFFFFFL;
            }
            case 5: {
                return value >= 0L;
            }
            case 1: {
                return value == 0L || value == 1L;
            }
            case 2: {
                return value >= 0L && value <= Integer.MAX_VALUE;
            }
        }
        return false;
    }
}

