/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.hpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import robaho.net.httpserver.http2.HTTP2ErrorCode;
import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.hpack.HTTP2HeaderField;

public class HeaderFields
implements Iterable<HTTP2HeaderField> {
    private static final Set<String> prohibitedHeaderFields = Set.of("connection");
    private static final Set<String> requiredHeaderFields = Set.of(":path", ":method", ":scheme");
    private static final Set<String> pseudoHeadersIn = Set.of(":authority", ":method", ":path", ":scheme");
    private final List<HTTP2HeaderField> fields = new ArrayList<HTTP2HeaderField>();
    private final Map<String, HTTP2HeaderField> pseudoHeaders = new HashMap<String, HTTP2HeaderField>();
    private boolean hasNonPseudoHeader = false;

    public void addHeaderField(HTTP2HeaderField field) throws HTTP2Exception {
        if (field.isPseudoHeader() && !pseudoHeadersIn.contains(field.getName())) {
            throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "invalid pseudo header " + field.getName());
        }
        if (prohibitedHeaderFields.contains(field.getName())) {
            throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "prohibited header field " + field.getName());
        }
        if (field.getName().equals("te") && !field.getValue().equals("trailers")) {
            throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "prohibited header field " + field.getName());
        }
        if (!field.isPseudoHeader()) {
            this.hasNonPseudoHeader = true;
        }
        if (field.isPseudoHeader() && this.hasNonPseudoHeader) {
            throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "Pseudo-header fields must appear before regular header fields");
        }
        if (field.isPseudoHeader() && this.pseudoHeaders.put(field.getName(), field) != null && requiredHeaderFields.contains(field.getName())) {
            throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "invalid duplicate header " + field.getName());
        }
        this.fields.add(field);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().equals("");
    }

    public void addAll(List<HTTP2HeaderField> httpFields) throws HTTP2Exception {
        for (HTTP2HeaderField field : httpFields) {
            this.addHeaderField(field);
        }
    }

    @Override
    public Iterator<HTTP2HeaderField> iterator() {
        return this.fields.iterator();
    }

    public void clear() {
        this.fields.clear();
        this.hasNonPseudoHeader = false;
    }

    public void validate() throws HTTP2Exception {
        for (String fieldName : requiredHeaderFields) {
            HTTP2HeaderField ph = this.pseudoHeaders.get(fieldName);
            if (ph != null && !HeaderFields.isEmpty(ph.getValue())) continue;
            throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "missing required header field " + fieldName);
        }
    }
}

