/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.extras;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class ProxyHandler
implements HttpHandler {
    private final ConcurrentMap<URI, HostPort> proxies = new ConcurrentHashMap<URI, HostPort>();
    private final HttpClient proxyClient;
    private final Optional<HostPort> defaultProxy;
    protected final Logger logger = Logger.getLogger("robaho.net.httpserver.ProxyHandler");
    private static int DEFAULT_BUFFER_SIZE = 16384;
    private static final Set<String> restrictedHeaders = Set.of("CONNECTION", "HOST", "UPGRADE", "CONTENT-LENGTH");

    public ProxyHandler() {
        this(Optional.empty());
    }

    public ProxyHandler(HostPort defaultProxy) {
        this(Optional.of(defaultProxy));
    }

    private ProxyHandler(Optional<HostPort> defaultProxy) {
        this.defaultProxy = defaultProxy;
        this.proxyClient = HttpClient.newBuilder().proxy(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                HostPort hp = (HostPort)ProxyHandler.this.proxies.get(uri);
                return List.of(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hp.server, hp.port)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                ProxyHandler.this.connectFailed(uri, sa, ioe);
            }
        }).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        if (exchange.getRequestMethod().equals("CONNECT")) {
            if (!this.authorizeConnect(exchange)) {
                return;
            }
            Socket s = SocketFactory.getDefault().createSocket();
            try {
                URI uri = exchange.getRequestURI();
                InetSocketAddress addr = new InetSocketAddress(uri.getScheme(), Integer.parseInt(uri.getSchemeSpecificPart()));
                try {
                    s.connect(addr);
                }
                catch (Exception e) {
                    this.logger.warning("failed to connect to " + String.valueOf(addr));
                    exchange.sendResponseHeaders(500, -1L);
                    if (s != null) {
                        s.close();
                    }
                    return;
                }
                this.logger.fine("connected to " + String.valueOf(s.getRemoteSocketAddress()));
                exchange.sendResponseHeaders(200, 0L);
                try {
                    exchange.getHttpContext().getServer().getExecutor().execute(() -> {
                        try {
                            ProxyHandler.transfer(s.getInputStream(), exchange.getResponseBody());
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    });
                    ProxyHandler.transfer(exchange.getRequestBody(), s.getOutputStream());
                    this.logger.fine("proxy connection to " + String.valueOf(s.getRemoteSocketAddress()) + " ended");
                    return;
                }
                catch (Throwable throwable) {
                    block26: {
                        this.logger.fine("proxy connection to " + String.valueOf(s.getRemoteSocketAddress()) + " ended");
                        if (s == null) break block26;
                        s.close();
                    }
                    return;
                }
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable addr) {
                        Throwable uri;
                        uri.addSuppressed(addr);
                    }
                }
            }
        }
        HostPort proxy = this.proxyTo(exchange).orElseThrow(() -> new IOException("proxy not configured for " + String.valueOf(exchange.getRequestURI())));
        URI uri = exchange.getRequestURI();
        if (uri.getScheme() == null) {
            try {
                uri = new URI(proxy.scheme, uri.getUserInfo(), exchange.getLocalAddress().getHostName(), exchange.getLocalAddress().getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException ex) {
                throw new IOException("invalid proxy uri ", ex);
            }
        }
        this.proxies.put(uri, proxy);
        try {
            HttpResponse<InputStream> response = this.proxyClient.send(HttpRequest.newBuilder(uri).headers(ProxyHandler.headers(exchange.getRequestHeaders())).method(exchange.getRequestMethod(), HttpRequest.BodyPublishers.ofInputStream(() -> exchange.getRequestBody())).build(), HttpResponse.BodyHandlers.ofInputStream());
            exchange.getResponseHeaders().putAll((Map<? extends String, ? extends List<String>>)response.headers().map());
            exchange.sendResponseHeaders(response.statusCode(), 0L);
            try (OutputStream os = exchange.getResponseBody();){
                ProxyHandler.transfer(response.body(), os);
            }
        }
        catch (InterruptedException ex) {
            throw new IOException("unable to proxy request to " + String.valueOf(exchange.getRequestURI()), ex);
        }
    }

    protected boolean authorizeConnect(HttpExchange exchange) {
        return true;
    }

    private static long transfer(InputStream in, OutputStream out) throws IOException {
        int read;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
        while ((read = in.read(buffer, 0, DEFAULT_BUFFER_SIZE)) >= 0) {
            out.write(buffer, 0, read);
            out.flush();
            if (transferred >= Long.MAX_VALUE) continue;
            try {
                transferred = Math.addExact(transferred, (long)read);
            }
            catch (ArithmeticException ignore) {
                transferred = Long.MAX_VALUE;
            }
        }
        return transferred;
    }

    private static String[] headers(Headers headers) {
        ArrayList copy = new ArrayList();
        headers.entrySet().stream().filter(e -> !restrictedHeaders.contains(((String)e.getKey()).toUpperCase())).forEach(e -> ((List)e.getValue()).forEach(v -> {
            copy.add((String)e.getKey());
            copy.add(v);
        }));
        return (String[])copy.toArray(String[]::new);
    }

    protected Optional<HostPort> proxyTo(HttpExchange exchange) {
        return this.defaultProxy;
    }

    protected void connectFailed(URI uri, SocketAddress sa, IOException ieo) {
    }

    public record HostPort(String server, int port, String scheme) {
    }
}

