/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.frame;

import java.util.EnumSet;
import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.frame.FrameType;

public enum FrameFlag {
    END_STREAM(1),
    ACK(1),
    END_HEADERS(4),
    PADDED(8),
    PRIORITY(32);

    byte value;

    private FrameFlag(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static EnumSet<FrameFlag> getEnumSet(byte value, FrameType type) throws HTTP2Exception {
        EnumSet<FrameFlag> result = EnumSet.noneOf(FrameFlag.class);
        if ((value & 1) == 1) {
            if (type == FrameType.SETTINGS || type == FrameType.PING) {
                result.add(ACK);
            } else {
                result.add(END_STREAM);
            }
            value = (byte)(value ^ 1);
        }
        for (FrameFlag flag : FrameFlag.values()) {
            if ((value & flag.value) == 0) continue;
            result.add(flag);
            value = (byte)(value ^ flag.value);
        }
        if (value != 0) {
            // empty if block
        }
        return result;
    }

    public static byte getValue(EnumSet<FrameFlag> flags) {
        byte result = 0;
        for (FrameFlag flag : flags) {
            result = (byte)(result | flag.getValue());
        }
        return result;
    }
}

