/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.hpack;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import robaho.net.httpserver.http2.HTTP2ErrorCode;
import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.Utils;
import robaho.net.httpserver.http2.frame.FrameFlag;
import robaho.net.httpserver.http2.frame.FrameHeader;
import robaho.net.httpserver.http2.frame.FrameType;
import robaho.net.httpserver.http2.hpack.HTTP2HeaderField;
import robaho.net.httpserver.http2.hpack.Huffman;
import robaho.net.httpserver.http2.hpack.RFC7541Parser;

public class HPackContext {
    private final List<HTTP2HeaderField> dynamicTable = new ArrayList<HTTP2HeaderField>(1024);

    public HTTP2HeaderField getHeaderField(int index) {
        if (index > 0 && index <= 61) {
            return RFC7541Parser.getHeaderField(index);
        }
        return this.dynamicTable.get(index - 62);
    }

    public void addHeaderField(HTTP2HeaderField field) {
        this.dynamicTable.add(0, field);
    }

    public List<HTTP2HeaderField> decodeFieldSegments(byte[] buffer) throws HTTP2Exception {
        ArrayList<HTTP2HeaderField> headers = new ArrayList<HTTP2HeaderField>();
        int index = 0;
        try {
            while (index < buffer.length) {
                HTTP2HeaderField headerField = new HTTP2HeaderField();
                if ((buffer[index] & 0x80) != 0) {
                    index = this.decodeIndexedHeaderField(buffer, index, headerField);
                } else if ((buffer[index] & 0x40) != 0) {
                    index = this.decodeFieldWithIncrementalIndexing(buffer, index, headerField);
                } else if ((buffer[index] & 0xF0) == 0) {
                    index = this.decodeLiteralFieldWithoutIndexing(buffer, index, headerField);
                } else if ((buffer[index] & 0xF0) == 16) {
                    index = this.decodeLiteralFieldNeverIndexed(buffer, index, headerField);
                } else {
                    if ((buffer[index] & 0xE0) == 32) {
                        if (!headers.isEmpty()) {
                            throw new HTTP2Exception(HTTP2ErrorCode.COMPRESSION_ERROR, "Dynamic table size update must occur at beginning of block");
                        }
                        index = this.decodeDynamicTableSizeUpdate(buffer, index);
                        continue;
                    }
                    throw new HTTP2Exception(HTTP2ErrorCode.COMPRESSION_ERROR, "Invalid header field representation " + buffer[index]);
                }
                headers.add(headerField);
            }
        }
        catch (HTTP2Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new HTTP2Exception(HTTP2ErrorCode.COMPRESSION_ERROR, (Throwable)e);
        }
        return headers;
    }

    private int decodeIndexedHeaderField(byte[] buffer, int index, HTTP2HeaderField headerField) throws HTTP2Exception {
        IndexValuePair pair = HPackContext.decodeUnsignedInteger(buffer, index, 7);
        int headerIndex = pair.value;
        index = pair.index;
        HTTP2HeaderField field = this.getHeaderField(headerIndex);
        if (field == null) {
            throw new HTTP2Exception(HTTP2ErrorCode.COMPRESSION_ERROR, "Invalid header index " + headerIndex + ", dynamic: " + String.valueOf(this.dynamicTable));
        }
        headerField.setName(field.name);
        headerField.setValue(field.value);
        return index;
    }

    private int decodeFieldWithIncrementalIndexing(byte[] buffer, int index, HTTP2HeaderField headerField) throws HTTP2Exception {
        IndexValuePair pair = HPackContext.decodeUnsignedInteger(buffer, index, 6);
        int headerIndex = pair.value;
        index = pair.index;
        index = this.decodeFieldName(buffer, index, headerIndex, headerField);
        index = this.decodeFieldValue(buffer, index, headerField);
        this.dynamicTable.add(0, headerField);
        return index;
    }

    private int decodeLiteralFieldWithoutIndexing(byte[] buffer, int index, HTTP2HeaderField headerField) throws HTTP2Exception {
        IndexValuePair pair = HPackContext.decodeUnsignedInteger(buffer, index, 4);
        int headerIndex = pair.value;
        index = pair.index;
        index = this.decodeFieldName(buffer, index, headerIndex, headerField);
        index = this.decodeFieldValue(buffer, index, headerField);
        return index;
    }

    private int decodeDynamicTableSizeUpdate(byte[] buffer, int index) throws HTTP2Exception {
        IndexValuePair pair = HPackContext.decodeUnsignedInteger(buffer, index, 5);
        int size = pair.value;
        index = pair.index;
        if (size > 4096) {
            throw new HTTP2Exception(HTTP2ErrorCode.COMPRESSION_ERROR, "Dynamic table size update too large: " + size);
        }
        while (this.dynamicTable.size() > size) {
            this.dynamicTable.removeLast();
        }
        return index;
    }

    private int decodeFieldName(byte[] buffer, int index, int headerIndex, HTTP2HeaderField headerField) throws HTTP2Exception {
        if (headerIndex == 0) {
            boolean huffmanCode = (buffer[index] & 0x80) != 0;
            int length = buffer[index] & 0x7F;
            byte[] valueBytes = Arrays.copyOfRange(buffer, ++index, index + length);
            index += length;
            String value = huffmanCode ? Huffman.decode(valueBytes) : new String(valueBytes);
            if (!value.equals(value.toLowerCase())) {
                throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "header field name is not lowercase " + value);
            }
            headerField.setName(value);
        } else {
            HTTP2HeaderField field = this.getHeaderField(headerIndex);
            if (field == null) {
                throw new HTTP2Exception(HTTP2ErrorCode.COMPRESSION_ERROR, "Invalid header index " + headerIndex);
            }
            headerField.setName(field.name);
        }
        return index;
    }

    private int decodeFieldValue(byte[] buffer, int index, HTTP2HeaderField headerField) throws HTTP2Exception {
        boolean huffmanCode = (buffer[index] & 0x80) != 0;
        IndexValuePair pair = HPackContext.decodeUnsignedInteger(buffer, index, 7);
        index = pair.index;
        int length = pair.value;
        byte[] valueBytes = Arrays.copyOfRange(buffer, index, index + length);
        String value = huffmanCode ? Huffman.decode(valueBytes) : new String(valueBytes);
        headerField.setValue(value);
        return index + length;
    }

    private static IndexValuePair decodeUnsignedInteger(byte[] buffer, int index, int prefixBits) {
        int b;
        int value = buffer[index] & (1 << prefixBits) - 1;
        ++index;
        if (value < (1 << prefixBits) - 1) {
            return new IndexValuePair(index, value);
        }
        int m = 0;
        do {
            b = buffer[index] & 0xFF;
            value += (b & 0x7F) << m;
            m += 7;
            ++index;
        } while ((b & 0x80) != 0);
        return new IndexValuePair(index, value);
    }

    private int decodeLiteralFieldNeverIndexed(byte[] buffer, int index, HTTP2HeaderField headerField) throws HTTP2Exception {
        IndexValuePair pair = HPackContext.decodeUnsignedInteger(buffer, index, 4);
        int headerIndex = pair.value;
        index = pair.index;
        index = this.decodeFieldName(buffer, index, headerIndex, headerField);
        index = this.decodeFieldValue(buffer, index, headerField);
        return index;
    }

    public static void writeHeaderFrame(Headers headers, OutputStream outputStream, int streamId) throws IOException {
        byte[] buffer = HPackContext.encodeHeadersFrame(headers);
        FrameHeader header = new FrameHeader(buffer.length, FrameType.HEADERS, EnumSet.of(FrameFlag.END_HEADERS), streamId);
        header.writeTo(outputStream);
        outputStream.write(buffer);
    }

    private static byte[] encodeHeadersFrame(Headers headers) {
        ArrayList<byte[]> fields = new ArrayList<byte[]>();
        for (String name : headers.keySet()) {
            Iterator iterator = headers.get(name).iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                byte[] header = HPackContext.encodeHeader(name.toLowerCase(), value);
                if (name.startsWith(":")) {
                    fields.add(0, header);
                    continue;
                }
                fields.add(header);
            }
        }
        return Utils.combineByteArrays(fields);
    }

    private static byte[] encodeHeader(String name, String value) {
        byte[] header;
        byte[] result;
        if (":status".equals(name) && (result = RFC7541Parser.STATUSES.get(value)) != null) {
            return result;
        }
        Integer index = RFC7541Parser.getIndex(name);
        byte[] buffer = new byte[]{0};
        if (index != null) {
            buffer = HPackContext.encodeIndexedField(index, 4);
        } else {
            byte[] nameBytes = name.getBytes();
            header = HPackContext.encodeString(nameBytes);
            buffer = Arrays.copyOf(buffer, buffer.length + header.length);
            System.arraycopy(header, 0, buffer, buffer.length - header.length, header.length);
        }
        byte[] valueBytes = value.getBytes();
        header = HPackContext.encodeString(valueBytes);
        buffer = Arrays.copyOf(buffer, buffer.length + header.length);
        System.arraycopy(header, 0, buffer, buffer.length - header.length, header.length);
        return buffer;
    }

    private static byte[] encodeString(byte[] value) {
        byte[] buffer = new byte[]{};
        if (value.length < 128) {
            buffer = Arrays.copyOf(buffer, buffer.length + 1);
            buffer[buffer.length - 1] = (byte)value.length;
        } else {
            buffer = Arrays.copyOf(buffer, buffer.length + 1);
            buffer[buffer.length - 1] = (byte)(value.length | 0x80);
            buffer = Arrays.copyOf(buffer, buffer.length + 1);
            buffer[buffer.length - 1] = (byte)(value.length >> 7);
        }
        buffer = Arrays.copyOf(buffer, buffer.length + value.length);
        System.arraycopy(value, 0, buffer, buffer.length - value.length, value.length);
        return buffer;
    }

    private static byte[] encodeIndexedField(int index, int prefixBits) {
        byte[] buffer = new byte[1];
        int mask = (1 << prefixBits) - 1;
        if (index < mask) {
            buffer[0] = (byte)index;
            return buffer;
        }
        buffer[0] = (byte)mask;
        index -= mask;
        while (index >= 128) {
            buffer = Arrays.copyOf(buffer, buffer.length + 1);
            buffer[buffer.length - 1] = (byte)(index & 0x7F | 0x80);
            index >>>= 7;
        }
        buffer = Arrays.copyOf(buffer, buffer.length + 1);
        buffer[buffer.length - 1] = (byte)index;
        return buffer;
    }

    private record IndexValuePair(int index, int value) {
    }
}

