/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.websockets;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import robaho.net.httpserver.Utils;
import robaho.net.httpserver.websockets.Util;
import robaho.net.httpserver.websockets.WebSocket;

public abstract class WebSocketHandler
implements HttpHandler {
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        Headers headers = exchange.getRequestHeaders();
        if (!WebSocketHandler.isWebsocketRequested(headers)) {
            exchange.sendResponseHeaders(400, -1L);
            return;
        }
        if (!"13".equalsIgnoreCase(headers.getFirst("sec-websocket-version"))) {
            Util.sendResponseHeaders(exchange, 400, "Invalid Websocket-Version " + headers.getFirst("sec-websocket-version"));
            return;
        }
        if (!headers.containsKey("sec-websocket-key")) {
            Util.sendResponseHeaders(exchange, 400, "Missing Websocket-Key");
            return;
        }
        WebSocket webSocket = this.openWebSocket(exchange);
        try {
            exchange.getResponseHeaders().add("sec-websocket-accept", Util.makeAcceptKey(headers.getFirst("sec-websocket-key")));
        }
        catch (NoSuchAlgorithmException e) {
            Util.sendResponseHeaders(exchange, 500, "The SHA-1 Algorithm required for websockets is not available on the server.");
            return;
        }
        if (headers.containsKey("sec-websocket-protocol")) {
            exchange.getResponseHeaders().add("sec-websocket-protocol", headers.getFirst("sec-websocket-protocol").split(",")[0]);
        }
        exchange.getResponseHeaders().add("Upgrade", "websocket");
        exchange.getResponseHeaders().add("Connection", "Upgrade");
        exchange.sendResponseHeaders(101, 0L);
        webSocket.readWebsocket();
    }

    public static boolean isWebsocketRequested(Headers headers) {
        Object values = headers.get("Connection");
        if (values == null || values.stream().filter(s -> Utils.containsIgnoreCase(s, "Upgrade")).findAny().isEmpty()) {
            return false;
        }
        String upgrade = headers.getFirst("Upgrade");
        return "websocket".equalsIgnoreCase(upgrade);
    }

    protected abstract WebSocket openWebSocket(HttpExchange var1);
}

