/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import robaho.net.httpserver.HttpContextImpl;

class ContextList {
    private final List<HttpContextImpl> list = new CopyOnWriteArrayList<HttpContextImpl>();
    private final Map<CacheKey, HttpContextImpl> cache = new ConcurrentHashMap<CacheKey, HttpContextImpl>();

    ContextList() {
    }

    public synchronized void add(HttpContextImpl ctx) {
        assert (ctx.getPath() != null);
        if (this.contains(ctx)) {
            throw new IllegalArgumentException("cannot add context to list");
        }
        this.list.add(ctx);
    }

    boolean contains(HttpContextImpl ctx) {
        return this.findContext(ctx.getProtocol(), ctx.getPath(), true) != null;
    }

    public int size() {
        return this.list.size();
    }

    HttpContextImpl findContext(String protocol, String path) {
        CacheKey key = new CacheKey(protocol, path);
        HttpContextImpl ctx = this.cache.get(key);
        if (ctx != null) {
            return ctx;
        }
        ctx = this.findContext(protocol, path, false);
        if (ctx != null && ctx.getPath().equals(path)) {
            this.cache.put(key, ctx);
        }
        return ctx;
    }

    HttpContextImpl findContext(String protocol, String path, boolean exact) {
        String _protocol = protocol.toLowerCase(Locale.ROOT);
        String longest = "";
        HttpContextImpl lc = null;
        for (HttpContextImpl ctx : this.list) {
            if (!ctx.getProtocol().equals(_protocol)) continue;
            String cpath = ctx.getPath();
            if (exact && !cpath.equals(path) || !exact && !path.startsWith(cpath) || cpath.length() <= longest.length()) continue;
            longest = cpath;
            lc = ctx;
        }
        return lc;
    }

    public synchronized void remove(String protocol, String path) throws IllegalArgumentException {
        HttpContextImpl ctx = this.findContext(protocol, path, true);
        if (ctx == null) {
            throw new IllegalArgumentException("cannot remove element from list");
        }
        this.list.remove(ctx);
    }

    public synchronized void remove(HttpContextImpl context) throws IllegalArgumentException {
        for (HttpContextImpl ctx : this.list) {
            if (!ctx.equals(context)) continue;
            this.list.remove(ctx);
            return;
        }
        throw new IllegalArgumentException("no such context in list");
    }

    private record CacheKey(String protocol, String path) {
    }
}

