/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NoSyncBufferedInputStream
extends FilterInputStream {
    protected byte[] buf = new byte[1024];
    protected int count;
    protected int pos;

    private InputStream getInIfOpen() throws IOException {
        InputStream input = this.in;
        if (input == null) {
            throw new IOException("Stream closed");
        }
        return input;
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    private byte[] getBufIfOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
        return this.buf;
    }

    public NoSyncBufferedInputStream(InputStream in) {
        super(in);
    }

    private void fill() throws IOException {
        this.pos = 0;
        this.count = 0;
        int n = this.getInIfOpen().read(this.buf);
        if (n > 0) {
            this.count = n;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.getBufIfOpen()[this.pos++] & 0xFF;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.buf.length) {
                return this.getInIfOpen().read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.getBufIfOpen(), this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        InputStream input;
        this.ensureOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        do {
            int nread;
            if ((nread = this.read1(b, off + n, len - n)) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while ((input = this.in) == null || input.available() > 0);
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            return this.getInIfOpen().skip(n);
        }
        long skipped = avail < n ? avail : n;
        this.pos += (int)skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        int n = this.count - this.pos;
        if (n > 0) {
            return n;
        }
        return this.getInIfOpen().available();
    }

    @Override
    public void close() throws IOException {
        if (this.buf != null) {
            this.buf = null;
            super.close();
        }
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        int avail = this.count - this.pos;
        if (avail > 0) {
            out.write(this.buf, this.pos, this.count - this.pos);
            this.pos = this.count;
        }
        return super.transferTo(out);
    }
}

