/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class OpenAddressIntMap<T> {
    private int capacity;
    private int mask;
    private Entry[] entries;
    private int size;
    private int used;

    public OpenAddressIntMap(int capacity) {
        --capacity;
        capacity |= capacity >> 1;
        capacity |= capacity >> 2;
        capacity |= capacity >> 4;
        capacity |= capacity >> 8;
        capacity |= capacity >> 16;
        this.capacity = ++capacity;
        this.mask = capacity - 1;
        this.entries = new Entry[capacity];
    }

    public synchronized T put(int key, T value) {
        Entry entry;
        int index;
        if (this.used >= this.capacity / 2) {
            this.resize();
        }
        int start = index = key & this.mask;
        int sentinel = -1;
        while ((entry = this.entries[index]) != null) {
            if (entry.key == key) {
                Object oldValue = entry.value;
                entry.value = value;
                if (value == null) {
                    --this.size;
                }
                return (T)oldValue;
            }
            if (entry.value == null) {
                sentinel = index;
            }
            if ((index = index + 1 & this.mask) != start) continue;
            this.resize();
            start = index = key & this.mask;
            sentinel = -1;
        }
        if (value == null) {
            return null;
        }
        this.entries[sentinel == -1 ? index : sentinel] = new Entry(key, value);
        ++this.size;
        ++this.used;
        return null;
    }

    private void resize() {
        OpenAddressIntMap<Object> newMap = new OpenAddressIntMap<Object>(this.capacity << 1);
        for (Entry entry : this.entries) {
            if (entry == null || entry.value == null) continue;
            newMap.put(entry.key, entry.value);
        }
        this.entries = newMap.entries;
        this.capacity = newMap.capacity;
        this.mask = newMap.mask;
        this.size = newMap.size;
        this.used = newMap.used;
    }

    public T get(int key) {
        Entry entry;
        int index;
        int start = index = key & this.mask;
        while ((entry = this.entries[index]) != null) {
            if (entry.key == key) {
                return (T)entry.value;
            }
            if ((index = index + 1 & this.mask) != start) continue;
            break;
        }
        return null;
    }

    public T getOrDefault(int key, T defaultValue) {
        T value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.entries, null);
    }

    public Iterable<T> values() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Entry entry : this.entries) {
            if (entry == null || entry.value == null) continue;
            result.add(entry.value);
        }
        return Collections.unmodifiableList(result);
    }

    public <T2> Set<Map.Entry<Integer, T2>> entrySet(Function<T, T2> valueMapper) {
        HashSet<Map.Entry<Integer, Object>> result = new HashSet<Map.Entry<Integer, Object>>();
        for (Entry entry : this.entries) {
            if (entry == null) continue;
            result.add(Map.entry(entry.key, valueMapper != null ? valueMapper.apply(entry.value) : entry.value));
        }
        return Collections.unmodifiableSet(result);
    }

    private static class Entry {
        int key;
        Object value;

        Entry(int key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

