/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.util.Arrays;
import java.util.function.BiConsumer;

public class OpenAddressMap {
    private int capacity;
    private int mask;
    private int size;
    private Entry[] entries;

    public OpenAddressMap(int capacity) {
        --capacity;
        capacity |= capacity >> 1;
        capacity |= capacity >> 2;
        capacity |= capacity >> 4;
        capacity |= capacity >> 8;
        capacity |= capacity >> 16;
        this.capacity = ++capacity;
        this.mask = capacity - 1;
        this.entries = new Entry[capacity];
    }

    public Object put(String key, Object value) {
        Entry entry;
        int index;
        int start = index = key.hashCode() & this.mask;
        int sentinel = -1;
        while ((entry = this.entries[index]) != null) {
            if (entry.key.equals(key)) {
                Object oldValue = entry.value;
                entry.value = value;
                if (value == null) {
                    --this.size;
                }
                return oldValue;
            }
            if (entry.value == null) {
                sentinel = index;
            }
            if ((index = index + 1 & this.mask) != start) continue;
            this.resize();
            start = index = key.hashCode() & this.mask;
        }
        this.entries[sentinel == -1 ? index : sentinel] = new Entry(key, value);
        ++this.size;
        return null;
    }

    private void resize() {
        OpenAddressMap newMap = new OpenAddressMap(this.capacity << 1);
        for (Entry entry : this.entries) {
            if (entry == null) continue;
            newMap.put(entry.key, entry.value);
        }
        this.entries = newMap.entries;
        this.capacity = newMap.capacity;
        this.mask = newMap.mask;
    }

    public Object get(String key) {
        Entry entry;
        int index;
        int start = index = key.hashCode() & this.mask;
        while ((entry = this.entries[index]) != null) {
            if (entry.key.equals(key)) {
                return entry.value;
            }
            if ((index = index + 1 & this.mask) != start) continue;
            break;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.entries, null);
    }

    public void forEach(BiConsumer<String, Object> action) {
        for (Entry entry : this.entries) {
            if (entry == null || entry.value == null) continue;
            action.accept(entry.key, entry.value);
        }
    }

    private static class Entry {
        String key;
        Object value;

        Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

