/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import com.sun.net.httpserver.Headers;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import robaho.net.httpserver.OpenAddressMap;

public class OptimizedHeaders
extends Headers {
    private final OpenAddressMap map;

    public OptimizedHeaders() {
        this.map = new OpenAddressMap(16);
    }

    public OptimizedHeaders(int capacity) {
        this.map = new OpenAddressMap(capacity);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    public List<String> get(Object key) {
        Object o = this.map.get(this.normalize((String)key));
        return o == null ? null : (o instanceof String ? Arrays.asList((String)o) : (List<String>)o);
    }

    @Override
    public List<String> put(String key, List<String> value) {
        Object o = this.map.put(this.normalize(key), value);
        return o == null ? null : (o instanceof String ? Arrays.asList((String)o) : (List<String>)o);
    }

    @Override
    public List<String> remove(Object key) {
        Object o = this.map.put(this.normalize((String)key), null);
        return o == null ? null : (o instanceof String ? Arrays.asList((String)o) : (List<String>)o);
    }

    @Override
    public String getFirst(String key) {
        Object o = this.map.get(this.normalize(key));
        return o == null ? null : (o instanceof String ? (String)o : (String)((List)o).getFirst());
    }

    private String normalize(String key) {
        int i;
        int len = key.length();
        if (len == 0) {
            return key;
        }
        for (i = 0; i < len; ++i) {
            char c = key.charAt(i);
            if (c == '\r' || c == '\n') {
                throw new IllegalArgumentException("illegal character in key");
            }
            if (i == 0 ? c >= 'a' && c <= 'z' : c >= 'A' && c <= 'Z') break;
        }
        if (i == len) {
            return key;
        }
        System.out.println("normalizing key: " + key);
        char[] buffer = key.toCharArray();
        while (i < len) {
            char c = buffer[i];
            if (i == 0 && c >= 'a' && c <= 'z') {
                buffer[i] = (char)(c - 32);
            } else if (i != 0 && c >= 'A' && c <= 'Z') {
                buffer[i] = (char)(c + 32);
            } else if (c == '\r' || c == '\n') {
                throw new IllegalArgumentException("illegal character in key");
            }
            ++i;
        }
        return new String(buffer);
    }

    @Override
    public void add(String key, String value) {
        Object o = this.map.get(this.normalize(key));
        if (o == null) {
            this.map.put(this.normalize(key), value);
        } else if (o instanceof String) {
            this.map.put(this.normalize(key), Arrays.asList((String)o, value));
        } else {
            ((List)o).add(value);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void set(String key, String value) {
        this.map.put(this.normalize(key), value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.get(this.normalize((String)key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.entrySet().stream().anyMatch(e -> ((List)e.getValue()).contains((String)value));
    }

    @Override
    public Set<String> keySet() {
        return this.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toSet());
    }

    @Override
    public Collection<List<String>> values() {
        return this.entrySet().stream().map(e -> (List)e.getValue()).collect(Collectors.toSet());
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        HashSet<Map.Entry<String, List<String>>> set = new HashSet<Map.Entry<String, List<String>>>();
        this.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(k, v) -> set.add(new AbstractMap.SimpleEntry<String, List>((String)k, (List)v))));
        return set;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super List<String>> action) {
        this.map.forEach((String k, Object v) -> action.accept((String)k, (List<String>)(v instanceof String ? List.of((String)v) : (List<String>)v)));
    }
}

