/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.frame;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import robaho.net.httpserver.http2.HTTP2ErrorCode;
import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.Utils;
import robaho.net.httpserver.http2.frame.BaseFrame;
import robaho.net.httpserver.http2.frame.FrameFlag;
import robaho.net.httpserver.http2.frame.FrameHeader;
import robaho.net.httpserver.http2.frame.FrameType;

public class HeadersFrame
extends BaseFrame {
    private int padLength;
    private boolean isExclusive;
    private long dependentStreamId;
    private int weight;
    private byte[] headerBlock;
    private byte[] padding;

    public HeadersFrame() {
        this(new FrameHeader(0, FrameType.HEADERS, FrameFlag.NONE, 0));
    }

    public HeadersFrame(FrameHeader header) {
        super(header);
    }

    public int getPadLength() {
        return this.padLength;
    }

    public void setPadLength(int padLength) {
        this.padLength = padLength;
    }

    public boolean getIsExclusive() {
        return this.isExclusive;
    }

    public void setIsExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public long getDependentStream() {
        return this.dependentStreamId;
    }

    public void setDependentStream(long streamIdentifier) {
        this.dependentStreamId = streamIdentifier;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public byte[] getHeaderBlock() {
        return this.headerBlock;
    }

    public void setHeaderBlock(byte[] headerBlock) {
        this.headerBlock = headerBlock;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public void setPadding(byte[] padding) {
        this.padding = padding;
    }

    public static HeadersFrame parse(byte[] frameBody, FrameHeader header) throws HTTP2Exception, Exception {
        if (frameBody == null) {
            throw new HTTP2Exception(HTTP2ErrorCode.FRAME_SIZE_ERROR);
        }
        if (header.getLength() != frameBody.length) {
            throw new HTTP2Exception(HTTP2ErrorCode.FRAME_SIZE_ERROR);
        }
        int paramIndex = 0;
        HeadersFrame headersFrame = new HeadersFrame(header);
        if (header.getFlags().contains((Object)FrameFlag.PADDED)) {
            int padLength = Utils.convertToInt(frameBody, paramIndex, 1);
            if (padLength >= header.getLength()) {
                throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR);
            }
            headersFrame.setPadLength(padLength);
            ++paramIndex;
        }
        if (header.getFlags().contains((Object)FrameFlag.PRIORITY)) {
            int streamId = Utils.convertToInt(frameBody, paramIndex, 4);
            paramIndex += 4;
            if (((long)streamId & 0x80000000L) == 0x80000000L) {
                headersFrame.setIsExclusive(true);
            }
            headersFrame.setDependentStream((long)streamId & Integer.MAX_VALUE);
            if (headersFrame.dependentStreamId == (long)header.getStreamIdentifier()) {
                throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR);
            }
            headersFrame.setWeight((frameBody[paramIndex] & 0xFF) + 1);
            ++paramIndex;
        }
        headersFrame.setHeaderBlock(Arrays.copyOfRange(frameBody, paramIndex, header.getLength() - headersFrame.getPadLength()));
        return headersFrame;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        byte[] buffer = this.getHeaderBlock();
        FrameHeader.writeTo(os, buffer.length, FrameType.HEADERS, EnumSet.of(FrameFlag.END_HEADERS), this.getHeader().getStreamIdentifier());
        os.write(buffer);
        os.flush();
    }

    @Override
    public byte[] encode() {
        throw new UnsupportedOperationException("use HPackContext encodeFrameHeaders()");
    }
}

