/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.websockets;

public enum OpCode {
    Continuation(0),
    Text(1),
    Binary(2),
    Close(8),
    Ping(9),
    Pong(10);

    private final byte code;

    public static OpCode find(byte value) {
        for (OpCode opcode : OpCode.values()) {
            if (opcode.getValue() != value) continue;
            return opcode;
        }
        return null;
    }

    private OpCode(int code) {
        this.code = (byte)code;
    }

    public byte getValue() {
        return this.code;
    }

    public boolean isControlFrame() {
        return this == Close || this == Ping || this == Pong;
    }
}

