/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.websockets;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import robaho.net.httpserver.websockets.CloseCode;
import robaho.net.httpserver.websockets.CloseFrame;
import robaho.net.httpserver.websockets.OpCode;
import robaho.net.httpserver.websockets.State;
import robaho.net.httpserver.websockets.WebSocketException;
import robaho.net.httpserver.websockets.WebSocketFrame;

public abstract class WebSocket {
    protected final System.Logger logger = System.getLogger("robaho.net.httpserver.websockets");
    private final InputStream in;
    private final OutputStream out;
    private OpCode continuousOpCode = null;
    private final List<WebSocketFrame> continuousFrames = new LinkedList<WebSocketFrame>();
    private volatile State state = State.UNCONNECTED;
    private Lock lock = new ReentrantLock();
    private final URI uri;

    protected WebSocket(HttpExchange exchange) {
        this.uri = exchange.getRequestURI();
        this.logger.log(System.Logger.Level.INFO, "connecting websocket {0}", this.uri);
        this.state = State.CONNECTING;
        this.in = exchange.getRequestBody();
        this.out = exchange.getResponseBody();
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    protected void onOpen() throws WebSocketException {
    }

    protected abstract void onClose(CloseCode var1, String var2, boolean var3);

    protected abstract void onMessage(WebSocketFrame var1) throws WebSocketException;

    protected abstract void onPong(WebSocketFrame var1) throws WebSocketException;

    protected void onException(IOException exception) {
        if (this.state != State.CLOSING && this.state != State.CLOSED) {
            this.logger.log(System.Logger.Level.TRACE, "exception on websocket", (Throwable)exception);
        }
    }

    protected void onFrameReceived(WebSocketFrame frame) {
        this.logger.log(System.Logger.Level.TRACE, "frame received: {0}", frame);
    }

    protected void onFrameSent(WebSocketFrame frame) {
        this.logger.log(System.Logger.Level.TRACE, "frame sent: {0}", frame);
    }

    public void close(CloseCode code, String reason, boolean initiatedByRemote) throws IOException {
        this.logger.log(System.Logger.Level.INFO, "closing websocket {0}", this.uri);
        State oldState = this.state;
        this.state = State.CLOSING;
        if (oldState == State.OPEN) {
            this.sendFrame(new CloseFrame(code, reason));
        } else {
            this.doClose(code, reason, initiatedByRemote);
        }
    }

    void doClose(CloseCode code, String reason, boolean initiatedByRemote) {
        if (this.state == State.CLOSED) {
            return;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.state = State.CLOSED;
        this.onClose(code, reason, initiatedByRemote);
    }

    private void handleCloseFrame(WebSocketFrame frame) throws IOException {
        CloseCode code = CloseCode.NormalClosure;
        String reason = "";
        if (frame instanceof CloseFrame) {
            code = ((CloseFrame)frame).getCloseCode();
            reason = ((CloseFrame)frame).getCloseReason();
        }
        this.logger.log(System.Logger.Level.TRACE, "handleCloseFrame: {0}, code={1}, reason={2}, state {3}", new Object[]{this.uri, code, reason, this.state});
        if (this.state == State.CLOSING) {
            this.doClose(code, reason, false);
        } else {
            this.close(code, reason, true);
        }
    }

    private void handleFrameFragment(WebSocketFrame frame) throws IOException {
        if (frame.getOpCode() != OpCode.Continuation) {
            if (this.continuousOpCode != null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Previous continuous frame sequence not completed.");
            }
            this.continuousOpCode = frame.getOpCode();
            this.continuousFrames.clear();
            this.continuousFrames.add(frame);
        } else if (frame.isFin()) {
            if (this.continuousOpCode == null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Continuous frame sequence was not started.");
            }
            this.continuousFrames.add(frame);
            this.onMessage(new WebSocketFrame(this.continuousOpCode, this.continuousFrames));
            this.continuousOpCode = null;
            this.continuousFrames.clear();
        } else {
            if (this.continuousOpCode == null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Continuous frame sequence was not started.");
            }
            this.continuousFrames.add(frame);
        }
    }

    private void handleWebsocketFrame(WebSocketFrame frame) throws IOException {
        this.onFrameReceived(frame);
        if (frame.getOpCode() == OpCode.Close) {
            this.handleCloseFrame(frame);
        } else if (frame.getOpCode() == OpCode.Ping) {
            this.sendFrame(new WebSocketFrame(OpCode.Pong, true, frame.getBinaryPayload()));
        } else if (frame.getOpCode() == OpCode.Pong) {
            this.onPong(frame);
        } else if (!frame.isFin() || frame.getOpCode() == OpCode.Continuation) {
            this.handleFrameFragment(frame);
        } else {
            if (this.continuousOpCode != null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Continuous frame sequence not completed.");
            }
            if (frame.getOpCode() == OpCode.Text || frame.getOpCode() == OpCode.Binary) {
                this.onMessage(frame);
            } else {
                throw new WebSocketException(CloseCode.ProtocolError, "Non control or continuous frame expected.");
            }
        }
    }

    public void ping(byte[] payload) throws IOException {
        this.sendFrame(new WebSocketFrame(OpCode.Ping, true, payload));
    }

    /*
     * Exception decompiling
     */
    void readWebsocket() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void send(byte[] payload) throws IOException {
        this.sendFrame(new WebSocketFrame(OpCode.Binary, true, payload));
    }

    public void send(String payload) throws IOException {
        this.sendFrame(new WebSocketFrame(OpCode.Text, true, payload));
    }

    public void sendFrame(WebSocketFrame frame) throws IOException {
        this.lock.lock();
        try {
            this.onFrameSent(frame);
            frame.write(this.out);
        }
        finally {
            this.lock.unlock();
        }
    }
}

