/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import robaho.net.httpserver.AuthFilter;
import robaho.net.httpserver.ServerImpl;

class HttpContextImpl
extends HttpContext {
    private final String path;
    private final String protocol;
    private final ServerImpl server;
    private final AuthFilter authfilter;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final List<Filter> sfilters = new CopyOnWriteArrayList<Filter>();
    private final List<Filter> ufilters = new CopyOnWriteArrayList<Filter>();
    private Authenticator authenticator;
    private HttpHandler handler;

    HttpContextImpl(String protocol, String path, HttpHandler cb, ServerImpl server) {
        if (path == null || protocol == null || path.length() < 1 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Illegal value for path or protocol");
        }
        this.protocol = protocol.toLowerCase(Locale.ROOT);
        this.path = path;
        if (!this.protocol.equals("http") && !this.protocol.equals("https")) {
            throw new IllegalArgumentException("Illegal value for protocol");
        }
        this.handler = cb;
        this.server = server;
        this.authfilter = new AuthFilter(null);
        this.sfilters.add(this.authfilter);
    }

    @Override
    public HttpHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(HttpHandler h) {
        if (h == null) {
            throw new NullPointerException("Null handler parameter");
        }
        if (this.handler != null) {
            throw new IllegalArgumentException("handler already set");
        }
        this.handler = h;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public HttpServer getServer() {
        return this.server.getWrapper();
    }

    ServerImpl getServerImpl() {
        return this.server;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<Filter> getFilters() {
        return this.ufilters;
    }

    List<Filter> getSystemFilters() {
        return this.sfilters;
    }

    @Override
    public Authenticator setAuthenticator(Authenticator auth) {
        Authenticator old = this.authenticator;
        this.authenticator = auth;
        this.authfilter.setAuthenticator(auth);
        return old;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    System.Logger getLogger() {
        return this.server.getLogger();
    }
}

