/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.frame;

import java.io.IOException;
import java.io.OutputStream;
import robaho.net.httpserver.http2.HTTP2ErrorCode;
import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.Utils;
import robaho.net.httpserver.http2.frame.BaseFrame;
import robaho.net.httpserver.http2.frame.FrameFlag;
import robaho.net.httpserver.http2.frame.FrameHeader;
import robaho.net.httpserver.http2.frame.FrameType;

public class WindowUpdateFrame
extends BaseFrame {
    private int windowSizeIncrement;

    public WindowUpdateFrame(FrameHeader header) {
        super(header);
    }

    public WindowUpdateFrame(int streamId, int increment) {
        super(new FrameHeader(4, FrameType.WINDOW_UPDATE, FrameFlag.NONE, streamId));
        this.windowSizeIncrement = increment;
    }

    public int getWindowSizeIncrement() {
        return this.windowSizeIncrement;
    }

    public static WindowUpdateFrame parse(byte[] frameBody, FrameHeader header) throws HTTP2Exception {
        if (frameBody.length != 4) {
            throw new HTTP2Exception(HTTP2ErrorCode.FRAME_SIZE_ERROR);
        }
        WindowUpdateFrame frame = new WindowUpdateFrame(header);
        try {
            frame.windowSizeIncrement = Utils.convertToInt(frameBody, 0);
        }
        catch (Exception e) {
            throw new HTTP2Exception(HTTP2ErrorCode.INTERNAL_ERROR);
        }
        if (frame.windowSizeIncrement == 0) {
            throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "window size increment == 0");
        }
        return frame;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.getHeader().writeTo(os);
        Utils.writeBinary(os, this.windowSizeIncrement);
    }

    @Override
    public byte[] encode() {
        byte[] buffer = new byte[13];
        this.getHeader().encode(buffer);
        Utils.convertToBinary(buffer, 9, this.windowSizeIncrement);
        return buffer;
    }
}

