/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2;

import com.sun.net.httpserver.Headers;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import robaho.net.httpserver.HttpConnection;
import robaho.net.httpserver.OpenAddressIntMap;
import robaho.net.httpserver.OptimizedHeaders;
import robaho.net.httpserver.ServerConfig;
import robaho.net.httpserver.http2.HTTP2ErrorCode;
import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.HTTP2Stats;
import robaho.net.httpserver.http2.HTTP2Stream;
import robaho.net.httpserver.http2.Utils;
import robaho.net.httpserver.http2.frame.BaseFrame;
import robaho.net.httpserver.http2.frame.ContinuationFrame;
import robaho.net.httpserver.http2.frame.DataFrame;
import robaho.net.httpserver.http2.frame.FrameFlag;
import robaho.net.httpserver.http2.frame.FrameHeader;
import robaho.net.httpserver.http2.frame.FrameSerializer;
import robaho.net.httpserver.http2.frame.FrameType;
import robaho.net.httpserver.http2.frame.GoawayFrame;
import robaho.net.httpserver.http2.frame.HeadersFrame;
import robaho.net.httpserver.http2.frame.PingFrame;
import robaho.net.httpserver.http2.frame.ResetStreamFrame;
import robaho.net.httpserver.http2.frame.SettingIdentifier;
import robaho.net.httpserver.http2.frame.SettingParameter;
import robaho.net.httpserver.http2.frame.SettingsFrame;
import robaho.net.httpserver.http2.frame.SettingsMap;
import robaho.net.httpserver.http2.frame.WindowUpdateFrame;
import robaho.net.httpserver.http2.hpack.HPackContext;
import robaho.net.httpserver.http2.hpack.HTTP2HeaderField;
import robaho.net.httpserver.http2.hpack.HeaderFields;

public class HTTP2Connection {
    static final String PREFACE = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n";
    static final String PARTIAL_PREFACE = "\r\nSM\r\n\r\n";
    private final InputStream inputStream;
    final OutputStream outputStream;
    private int lastSeenStreamId = 0;
    final OpenAddressIntMap<HTTP2Stream> http2Streams = new OpenAddressIntMap(16);
    private final SettingsMap remoteSettings = new SettingsMap();
    private final SettingsMap localSettings = new SettingsMap();
    private final StreamHandler handler;
    final HttpConnection httpConnection;
    final System.Logger logger;
    final HPackContext hpack = new HPackContext();
    final AtomicLong sendWindow = new AtomicLong(65535L);
    final AtomicInteger receiveWindow = new AtomicInteger(65535);
    final AtomicInteger requestsInProgress = new AtomicInteger();
    final HTTP2Stats stats;
    private final int connectionWindowSize;
    private int maxConcurrentStreams = -1;
    private int highNumberStreams = 0;
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public HTTP2Connection(HttpConnection httpConnection, HTTP2Stats stats, InputStream input, OutputStream output, StreamHandler handler) {
        this.httpConnection = httpConnection;
        this.inputStream = input;
        this.outputStream = output;
        this.handler = handler;
        this.stats = stats;
        this.logger = System.getLogger("robaho.net.httpserver.http2");
        this.connectionWindowSize = ServerConfig.http2ConnectionWindowSize();
        this.localSettings.set(new SettingParameter(SettingIdentifier.SETTINGS_MAX_FRAME_SIZE, ServerConfig.http2MaxFrameSize()));
        this.localSettings.set(new SettingParameter(SettingIdentifier.SETTINGS_INITIAL_WINDOW_SIZE, ServerConfig.http2InitialWindowSize()));
        if (ServerConfig.http2MaxConcurrentStreams() != -1) {
            this.localSettings.set(new SettingParameter(SettingIdentifier.SETTINGS_MAX_CONCURRENT_STREAMS, ServerConfig.http2MaxConcurrentStreams()));
        }
        this.logger.log(System.Logger.Level.DEBUG, "opened http2 connection " + String.valueOf(httpConnection) + ", max concurrent streams " + ServerConfig.http2MaxConcurrentStreams());
    }

    public void debug() {
        this.logger.log(System.Logger.Level.INFO, this.toString() + " receive window " + this.receiveWindow.get() + " send window " + this.sendWindow.get() + " in progress " + this.requestsInProgress.get());
        for (HTTP2Stream stream : this.http2Streams.values()) {
            stream.debug();
        }
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    public String toString() {
        return "{" + String.valueOf(this.httpConnection) + ", streams=" + this.http2Streams.size() + ", high " + this.highNumberStreams + "}";
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (HTTP2Stream stream : this.http2Streams.values()) {
                stream.close();
            }
        }
    }

    public SettingsMap getRemoteSettings() {
        return this.remoteSettings;
    }

    public SettingsMap getLocalSettings() {
        return this.localSettings;
    }

    public void writeFrame(byte[] frame) throws IOException {
        this.writeFrame(List.of(frame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFrame(List<byte[]> partials) throws IOException {
        this.lock();
        try {
            this.logger.log(System.Logger.Level.TRACE, () -> "sending frame " + FrameHeader.debug((byte[])partials.get(0)));
            for (byte[] frame : partials) {
                this.outputStream.write(frame);
            }
            this.outputStream.flush();
            this.stats.flushes.incrementAndGet();
        }
        finally {
            this.unlock();
        }
    }

    public boolean hasProperPreface() throws IOException {
        String preface_match = this.httpConnection.isSSL() ? PREFACE : PARTIAL_PREFACE;
        byte[] preface = new byte[preface_match.length()];
        this.inputStream.read(preface);
        String prefaceStr = new String(preface, 0, preface.length);
        return prefaceStr.equals(preface_match);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void handle() throws Exception {
        try {
            this.processFrames();
        }
        catch (HTTP2Exception e) {
            this.logger.log(System.Logger.Level.DEBUG, "exception on http2 connection", (Throwable)e);
            this.sendGoAway(e.getErrorCode());
            throw e;
        }
    }

    private void processFrames() throws Exception {
        boolean inHeaders = false;
        int openStreamId = 0;
        ArrayList<byte[]> headerBlockFragments = new ArrayList<byte[]>();
        block12: while (!this.httpConnection.isClosed()) {
            BaseFrame frame = FrameSerializer.deserialize(this.inputStream);
            int streamId = frame.getHeader().getStreamIdentifier();
            if (streamId != 0 && streamId % 2 == 0) {
                throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "invalid stream id " + streamId + " on type " + String.valueOf((Object)frame.getHeader().getType()));
            }
            switch (frame.getHeader().getType()) {
                case SETTINGS: {
                    if (frame.getHeader().getFlags().contains(FrameFlag.ACK)) {
                        if (ServerConfig.http2MaxConcurrentStreams() == -1) continue block12;
                        this.maxConcurrentStreams = this.http2Streams.size() + ServerConfig.http2MaxConcurrentStreams();
                        continue block12;
                    }
                    this.updateRemoteSettings((SettingsFrame)frame);
                    this.sendSettingsAck();
                    continue block12;
                }
                case GOAWAY: {
                    GoawayFrame goaway = (GoawayFrame)frame;
                    if (goaway.errorCode == HTTP2ErrorCode.NO_ERROR) continue block12;
                    throw new IOException("received GOAWAY from remote " + String.valueOf((Object)goaway.errorCode));
                }
                case PING: {
                    if (frame.getHeader().getFlags().contains(FrameFlag.ACK)) continue block12;
                    this.sendPingAck((PingFrame)frame);
                    continue block12;
                }
                case WINDOW_UPDATE: {
                    if (streamId != 0) break;
                    int windowSizeIncrement = ((WindowUpdateFrame)frame).getWindowSizeIncrement();
                    this.sendWindow.addAndGet(windowSizeIncrement);
                    this.logger.log(System.Logger.Level.DEBUG, "received connection window update " + windowSizeIncrement + ", new size " + this.sendWindow.get());
                    if (this.sendWindow.get() <= Integer.MAX_VALUE) continue block12;
                    throw new HTTP2Exception(HTTP2ErrorCode.FLOW_CONTROL_ERROR, "maximum window size exceeded");
                }
                case NOT_IMPLEMENTED: {
                    if (inHeaders) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "NOT_IMPLEMENTED frame received while headers being received");
                    }
                    if (frame.getHeader().getStreamIdentifier() != 0) break;
                    continue block12;
                }
                case DATA: {
                    DataFrame dataFrame = (DataFrame)frame;
                    if (this.receiveWindow.addAndGet(-dataFrame.body.length) < this.connectionWindowSize / 10) {
                        this.sendWindowUpdate();
                    }
                    if (!inHeaders) break;
                    throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "DATA frame received while headers being received");
                }
                case HEADERS: {
                    if (inHeaders) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "HEADERS frame received on open stream");
                    }
                    if (streamId < this.lastSeenStreamId) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "HEADERS frame received out of order");
                    }
                    HTTP2Stream stream = this.http2Streams.get(streamId);
                    if (stream != null) {
                        if (!stream.isOpen() || stream.isHalfClosed()) {
                            throw new HTTP2Exception(HTTP2ErrorCode.STREAM_CLOSED, "HEADERS frame received on already closed stream");
                        }
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "HEADERS frame received on already established stream");
                    }
                    HeadersFrame headersFrame = (HeadersFrame)frame;
                    headerBlockFragments.add(headersFrame.getHeaderBlock());
                    if (headersFrame.getHeader().getFlags().contains(FrameFlag.END_HEADERS)) break;
                    inHeaders = true;
                    openStreamId = streamId;
                    continue block12;
                }
                case CONTINUATION: {
                    if (inHeaders && frame.getHeader().getStreamIdentifier() != openStreamId) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "HEADERS frame received on open stream");
                    }
                    if (!inHeaders) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "CONTINUATION frame received on closed stream");
                    }
                    ContinuationFrame continuationFrame = (ContinuationFrame)frame;
                    headerBlockFragments.add(continuationFrame.getHeaderBlock());
                    if (continuationFrame.getHeader().getFlags().contains(FrameFlag.END_HEADERS)) break;
                    continue block12;
                }
                case PRIORITY: {
                    if (inHeaders) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "PRIORITY frame received during headers receive");
                    }
                    if (streamId != 0) continue block12;
                    throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "PRIORITY frame received on stream 0");
                }
                case RST_STREAM: {
                    ResetStreamFrame resetFrame = (ResetStreamFrame)frame;
                    if (resetFrame.errorCode == HTTP2ErrorCode.NO_ERROR) continue block12;
                    if (streamId == 0) {
                        throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "RST_STREAM frame received on stream 0");
                    }
                    if (this.http2Streams.get(streamId) != null) break;
                    if (streamId <= this.lastSeenStreamId) continue block12;
                    throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "RST_STREAM frame received on non-existent stream");
                }
            }
            HTTP2Stream targetStream = this.http2Streams.get(streamId);
            if (targetStream == null) {
                if (this.lastSeenStreamId < streamId) {
                    int currentSize = this.http2Streams.size();
                    if (this.maxConcurrentStreams != -1 && currentSize >= this.maxConcurrentStreams) {
                        throw new HTTP2Exception(HTTP2ErrorCode.REFUSED_STREAM);
                    }
                    this.highNumberStreams = Math.max(this.highNumberStreams, currentSize);
                    byte[] headerBlock = Utils.combineByteArrays(headerBlockFragments);
                    HeaderFields fields = new HeaderFields();
                    fields.addAll(this.hpack.decodeFieldSegments(headerBlock));
                    fields.validate();
                    OptimizedHeaders requestHeaders = new OptimizedHeaders(fields.size() * 2);
                    for (HTTP2HeaderField field : fields) {
                        if (field.value == null) {
                            this.logger.log(System.Logger.Level.TRACE, () -> "ignoring null header for " + field.getName());
                            continue;
                        }
                        ((Headers)requestHeaders).add(field.normalizedName, field.value);
                    }
                    headerBlockFragments.clear();
                    inHeaders = false;
                    targetStream = new HTTP2Stream(streamId, this, requestHeaders, this.handler);
                    this.http2Streams.put(streamId, targetStream);
                    this.lastSeenStreamId = streamId;
                } else {
                    if (streamId <= this.lastSeenStreamId) {
                        if (frame.getHeader().getType() == FrameType.WINDOW_UPDATE) {
                            this.logger.log(System.Logger.Level.TRACE, () -> "received WINDOW_UPDATE on closed stream " + streamId);
                            continue;
                        }
                        throw new HTTP2Exception(HTTP2ErrorCode.STREAM_CLOSED, "frame " + String.valueOf((Object)frame.getHeader().getType()) + ", stream " + streamId + " is closed");
                    }
                    throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR, "frame " + String.valueOf((Object)frame.getHeader().getType()) + ", stream " + streamId + " not in order");
                }
            }
            targetStream.processFrame(frame);
        }
    }

    public void updateRemoteSettings(SettingsFrame remoteSettingFrame) throws HTTP2Exception {
        this.logger.log(System.Logger.Level.TRACE, () -> "updating remote settings");
        for (SettingParameter parameter : remoteSettingFrame.getSettingParameters()) {
            long oldInitialWindowSize = this.remoteSettings.getOrDefault((SettingIdentifier)SettingIdentifier.SETTINGS_INITIAL_WINDOW_SIZE, (SettingParameter)SettingParameter.DEFAULT_INITIAL_WINDOWSIZE).value;
            if (parameter.identifier == SettingIdentifier.SETTINGS_INITIAL_WINDOW_SIZE) {
                if (parameter.value > Integer.MAX_VALUE) {
                    throw new HTTP2Exception(HTTP2ErrorCode.FLOW_CONTROL_ERROR, "Invalid value for SETTINGS_INITIAL_WINDOW_SIZE " + parameter.value);
                }
                this.logger.log(System.Logger.Level.DEBUG, () -> "received initial window size of " + parameter.value);
                for (HTTP2Stream stream : this.http2Streams.values()) {
                    stream.sendWindow.addAndGet(parameter.value - oldInitialWindowSize);
                }
            }
            if (parameter.identifier == SettingIdentifier.SETTINGS_MAX_FRAME_SIZE) {
                this.logger.log(System.Logger.Level.DEBUG, () -> "received max frame size " + parameter.value);
            }
            this.getRemoteSettings().set(parameter);
        }
    }

    public void sendSettingsAck() throws IOException {
        try {
            byte[] frame = FrameHeader.encode(0, FrameType.SETTINGS, FrameFlag.FlagSet.of(FrameFlag.ACK), 0);
            this.writeFrame(frame);
        }
        finally {
            this.logger.log(System.Logger.Level.TRACE, () -> "sent Settings Ack");
        }
    }

    public void sendMySettings() throws IOException {
        try {
            FrameHeader header = new FrameHeader(0, FrameType.SETTINGS, FrameFlag.NONE, 0);
            SettingsFrame frame = new SettingsFrame(header);
            this.localSettings.forEach(setting -> frame.getSettingParameters().add((SettingParameter)setting));
            this.writeFrame(frame.encode());
        }
        finally {
            this.logger.log(System.Logger.Level.TRACE, () -> "sent My Settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWindowUpdate() throws IOException {
        int current = this.receiveWindow.get();
        try {
            int increment = this.connectionWindowSize - current;
            this.receiveWindow.addAndGet(increment);
            WindowUpdateFrame frame = new WindowUpdateFrame(0, increment);
            this.writeFrame(frame.encode());
        }
        finally {
            this.logger.log(System.Logger.Level.DEBUG, () -> "sent connection window update, previous " + current + ", now " + this.receiveWindow.get());
        }
    }

    InetSocketAddress getRemoteAddress() {
        return this.httpConnection.getRemoteAddress();
    }

    InetSocketAddress getLocalAddress() {
        return this.httpConnection.getLocalAddress();
    }

    public void sendGoAway(HTTP2ErrorCode errorCode) throws IOException {
        this.lock();
        try {
            GoawayFrame frame = new GoawayFrame(errorCode, this.lastSeenStreamId);
            frame.writeTo(this.outputStream);
            this.outputStream.flush();
        }
        finally {
            this.unlock();
        }
        this.logger.log(System.Logger.Level.TRACE, () -> "Sent GoAway " + String.valueOf((Object)errorCode) + ", last stream " + this.lastSeenStreamId);
    }

    public void sendResetStream(HTTP2ErrorCode errorCode, int streamId) throws IOException {
        ResetStreamFrame frame = new ResetStreamFrame(errorCode, streamId);
        this.writeFrame(frame.encode());
        this.logger.log(System.Logger.Level.TRACE, () -> "Sent ResetStream " + String.valueOf((Object)errorCode));
    }

    public void sendPing() throws IOException {
        PingFrame frame = new PingFrame();
        this.writeFrame(frame.encode());
        this.stats.pingsSent.incrementAndGet();
        this.logger.log(System.Logger.Level.TRACE, () -> "Sent Ping ");
    }

    private void sendPingAck(PingFrame ping) throws IOException {
        PingFrame frame = new PingFrame(ping);
        this.writeFrame(frame.encode());
        this.logger.log(System.Logger.Level.TRACE, "Sent Ping Ack");
    }

    public static void readFully(InputStream inputStream, byte[] buffer) throws IOException {
        if (buffer.length == 0) {
            return;
        }
        int bytesRead = 0;
        int offset = 0;
        int length = buffer.length;
        while (bytesRead != -1 && offset < length) {
            bytesRead = inputStream.read(buffer, offset, length - offset);
            if (bytesRead == -1) continue;
            offset += bytesRead;
        }
        if (offset == 0) {
            throw new EOFException("end of stream detected");
        }
        if (offset < length) {
            throw new IOException("failed to read the full buffer");
        }
    }

    public static interface StreamHandler {
        public void handleStream(HTTP2Stream var1, InputStream var2, OutputStream var3) throws IOException;

        public Executor getExecutor();
    }
}

