/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2;

import java.util.concurrent.atomic.AtomicLong;

public class HTTP2Stats {
    public final AtomicLong activeStreams = new AtomicLong();
    public final AtomicLong bytesSent = new AtomicLong();
    public final AtomicLong framesSent = new AtomicLong();
    public final AtomicLong flushes = new AtomicLong();
    public final AtomicLong sslConnections = new AtomicLong();
    public final AtomicLong nonsslConnections = new AtomicLong();
    public final AtomicLong totalStreams = new AtomicLong();
    public final AtomicLong pauses = new AtomicLong();
    public final AtomicLong pingsSent = new AtomicLong();
    private volatile long lastStatsTime = System.currentTimeMillis();

    public String stats() {
        long now = System.currentTimeMillis();
        double secs = (double)(now - this.lastStatsTime) / 1000.0;
        this.lastStatsTime = now;
        long _bytes = this.bytesSent.getAndSet(0L);
        long _frames = this.framesSent.getAndSet(0L);
        return "Http2 SSL Connections Since: " + this.sslConnections.getAndSet(0L) + "\nHttp2 Non-SSL Connections Since: " + this.nonsslConnections.getAndSet(0L) + "\nHttp2 Streams Since: " + this.totalStreams.getAndSet(0L) + "\nHttp2 Active Streams: " + this.activeStreams.get() + "\nHttp2 Frames Sent/sec: " + (long)((double)_frames / secs) + "\nHttp2 Bytes Sent/sec: " + (long)((double)_bytes / secs) + "\nHttp2 Avg Frame Size: " + (_frames == 0L ? 0L : _bytes / _frames) + "\nHttp2 Flushes/sec: " + (long)((double)this.flushes.getAndSet(0L) / secs) + "\nHttp2 Pauses/sec: " + (long)((double)this.pauses.getAndSet(0L) / secs) + "\nHttp2 Pings Sent Since: " + this.pingsSent.getAndSet(0L) + "\n";
    }
}

