/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.frame;

import java.io.IOException;
import java.io.OutputStream;
import robaho.net.httpserver.http2.Utils;
import robaho.net.httpserver.http2.frame.FrameFlag;
import robaho.net.httpserver.http2.frame.FrameType;

public class FrameHeader {
    private final int length;
    private final FrameType type;
    private final FrameFlag.FlagSet flags;
    private final int streamIdentifier;

    public int getLength() {
        return this.length;
    }

    public FrameType getType() {
        return this.type;
    }

    public FrameFlag.FlagSet getFlags() {
        return this.flags;
    }

    public int getStreamIdentifier() {
        return this.streamIdentifier;
    }

    public FrameHeader(int length, FrameType type, FrameFlag.FlagSet flags, int streamIdentifier) {
        this.length = length;
        this.type = type;
        this.flags = flags;
        this.streamIdentifier = streamIdentifier;
    }

    public String toString() {
        return "FrameHeader{length=" + this.length + ", type=" + String.valueOf((Object)this.type) + ", flags=" + String.valueOf(this.flags) + ", streamIdentifier=" + this.streamIdentifier + "}";
    }

    public static FrameHeader Parse(byte[] tmpBuffer) throws Exception {
        FrameHeader frameHeader = null;
        FrameType type = null;
        FrameFlag.FlagSet flag = null;
        int streamIdentifier = 0;
        int length = 0;
        int readIndex = 0;
        length = Utils.convertToInt(tmpBuffer, readIndex, 3);
        type = FrameType.getEnum(tmpBuffer[readIndex += 3]);
        flag = FrameFlag.getEnumSet(tmpBuffer[++readIndex], type);
        streamIdentifier = Utils.convertToInt(tmpBuffer, ++readIndex);
        readIndex += 4;
        frameHeader = new FrameHeader(length, type, flag, streamIdentifier &= Integer.MAX_VALUE);
        return frameHeader;
    }

    public static String debug(byte[] header) {
        try {
            FrameType type = FrameType.getEnum(header[3]);
            return "length=" + Utils.convertToInt(header, 0, 3) + ", type " + String.valueOf((Object)type) + ", flags " + String.valueOf(FrameFlag.getEnumSet(header[4], type)) + ", stream " + Utils.convertToInt(header, 5);
        }
        catch (Exception ex) {
            return "<unable to parse>";
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        Utils.writeBinary(os, this.length, 3);
        os.write(this.getType().value & 0xFF);
        os.write(this.flags.value());
        Utils.writeBinary(os, this.streamIdentifier);
    }

    public static void writeTo(OutputStream os, int length, FrameType frameType, FrameFlag.FlagSet flags, int streamId) throws IOException {
        Utils.writeBinary(os, length, 3);
        os.write(frameType.value & 0xFF);
        os.write(flags.value());
        Utils.writeBinary(os, streamId);
    }

    public static byte[] encode(int length, FrameType frameType, FrameFlag.FlagSet flags, int streamId) {
        byte[] buffer = new byte[9];
        Utils.convertToBinary(buffer, 0, length, 3);
        buffer[3] = (byte)(frameType.value & 0xFF);
        buffer[4] = flags.value();
        Utils.convertToBinary(buffer, 5, streamId, 4);
        return buffer;
    }

    public byte[] encode() {
        byte[] buffer = new byte[9];
        Utils.convertToBinary(buffer, 0, this.length, 3);
        buffer[3] = (byte)(this.type.value & 0xFF);
        buffer[4] = this.flags.value();
        Utils.convertToBinary(buffer, 5, this.streamIdentifier, 4);
        return buffer;
    }

    public byte[] encode(byte[] buffer) {
        Utils.convertToBinary(buffer, 0, this.length, 3);
        buffer[3] = (byte)(this.type.value & 0xFF);
        buffer[4] = this.flags.value();
        Utils.convertToBinary(buffer, 5, this.streamIdentifier, 4);
        return buffer;
    }
}

