/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.hpack;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Arrays;
import robaho.net.httpserver.http2.HTTP2ErrorCode;
import robaho.net.httpserver.http2.HTTP2Exception;

public class Huffman {
    private static HuffmanCodes huffmanCodes;

    private static HuffmanCodes getHuffmanCodes() throws FileNotFoundException, IOException, URISyntaxException {
        if (huffmanCodes == null) {
            HuffmanCode[] codes = new HuffmanCode[257];
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream is = classloader.getResourceAsStream("huffman_codes_rfc7541.txt");
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String line;
                int value = 0;
                while ((line = br.readLine()) != null) {
                    String code = line.substring(11, line.indexOf(32, 11));
                    code = code.replace("|", "");
                    codes[value] = new HuffmanCode(new HuffmanSequence(code.toCharArray()), value);
                    ++value;
                }
            }
            huffmanCodes = new HuffmanCodes(codes);
        }
        return huffmanCodes;
    }

    public static String decode(byte[] value) throws HTTP2Exception {
        HuffmanCodes codes;
        StringBuilder result = new StringBuilder();
        try {
            codes = Huffman.getHuffmanCodes();
        }
        catch (IOException ex) {
            throw new HTTP2Exception("Error reading huffman codes", ex);
        }
        catch (URISyntaxException ex) {
            throw new HTTP2Exception("Error reading huffman codes", ex);
        }
        CodeBuffer code = new CodeBuffer();
        for (int i = 0; i < value.length; ++i) {
            int unsignedByte = value[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((unsignedByte & 0x80) != 0) {
                    code.append('1');
                } else {
                    code.append('0');
                }
                unsignedByte <<= 1;
                Integer intValue = codes.get(code.sequence());
                if (intValue == null) continue;
                if (intValue == 256) {
                    throw new HTTP2Exception(HTTP2ErrorCode.COMPRESSION_ERROR, "decoded contains EOS " + String.valueOf(code));
                }
                result.append((char)(intValue & 0xFF));
                code.reset();
            }
        }
        if (code.length() > 7 || code.indexOf('0') >= 0) {
            throw new HTTP2Exception(HTTP2ErrorCode.COMPRESSION_ERROR, "decoded has incorrect padding " + String.valueOf(code));
        }
        return result.toString();
    }

    private static class HuffmanCodes {
        private final HuffmanCode[] codes;
        private final int[] offsets = new int[33];

        HuffmanCodes(HuffmanCode[] codes) {
            this.codes = codes;
            Arrays.sort(codes, (a, b) -> a.sequence.compareTo(b.sequence));
            Arrays.fill(this.offsets, -1);
            for (int i = 0; i < codes.length; ++i) {
                HuffmanSequence sequence = codes[i].sequence;
                int length = sequence.length;
                if (length > 32 || this.offsets[length] != -1) continue;
                this.offsets[length] = i;
            }
        }

        Integer get(HuffmanSequence sequence) {
            int index = this.offsets[sequence.length];
            if (index == -1) {
                return null;
            }
            while (index + 8 < this.codes.length && this.codes[index + 8].sequence.compareTo(sequence) < 0) {
                index += 8;
            }
            while (index + 4 < this.codes.length && this.codes[index + 4].sequence.compareTo(sequence) < 0) {
                index += 4;
            }
            int result = 0;
            while (index < this.codes.length && (result = this.codes[index].sequence.compareTo(sequence)) < 0) {
                ++index;
            }
            if (index < this.codes.length && result == 0) {
                return this.codes[index].value;
            }
            return null;
        }
    }

    private static class HuffmanCode {
        private final HuffmanSequence sequence;
        private final int value;

        HuffmanCode(HuffmanSequence sequence, int value) {
            this.sequence = sequence;
            this.value = value;
        }
    }

    private static class HuffmanSequence
    implements Comparable<HuffmanSequence> {
        private final char[] buffer;
        private final int length;
        private final int hash;

        HuffmanSequence(char[] buffer, int length) {
            this.buffer = buffer;
            this.length = length;
            this.hash = this.calculateHash();
        }

        HuffmanSequence(char[] buffer) {
            this(buffer, buffer.length);
        }

        private int calculateHash() {
            int hash = 0;
            for (int i = 0; i < this.length; ++i) {
                hash = 31 * hash + (this.buffer[i] == '1' ? 1 : 0);
            }
            return hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HuffmanSequence)) {
                return false;
            }
            HuffmanSequence other = (HuffmanSequence)obj;
            if (this.hash != other.hash) {
                return false;
            }
            return this.compareTo(other) == 0;
        }

        public String toString() {
            return new String(this.buffer, 0, this.length);
        }

        @Override
        public int compareTo(HuffmanSequence o) {
            if (this.length != o.length) {
                return this.length - o.length;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.buffer[i] == o.buffer[i]) continue;
                return this.buffer[i] - o.buffer[i];
            }
            return 0;
        }
    }

    private static class CodeBuffer {
        private char[] buffer = new char[32];
        private int length;

        private CodeBuffer() {
        }

        void append(char ch) {
            if (this.length >= this.buffer.length) {
                char[] newBuffer = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
            }
            this.buffer[this.length++] = ch;
        }

        void reset() {
            this.length = 0;
        }

        int length() {
            return this.length;
        }

        int indexOf(char c) {
            for (int i = 0; i < this.length; ++i) {
                if (this.buffer[i] != c) continue;
                return i;
            }
            return -1;
        }

        HuffmanSequence sequence() {
            return new HuffmanSequence(this.buffer, this.length);
        }

        public String toString() {
            return new String(this.buffer, 0, this.length);
        }
    }
}

