/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.websockets;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class Util {
    public static final String HEADER_UPGRADE = "Upgrade";
    public static final String HEADER_UPGRADE_VALUE = "websocket";
    public static final String HEADER_CONNECTION = "Connection";
    public static final String HEADER_CONNECTION_VALUE = "Upgrade";
    public static final String HEADER_WEBSOCKET_VERSION = "sec-websocket-version";
    public static final String HEADER_WEBSOCKET_VERSION_VALUE = "13";
    public static final String HEADER_WEBSOCKET_KEY = "sec-websocket-key";
    public static final String HEADER_WEBSOCKET_ACCEPT = "sec-websocket-accept";
    public static final String HEADER_WEBSOCKET_PROTOCOL = "sec-websocket-protocol";
    private static final String WEBSOCKET_KEY_MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String CONTENT_TYPE = "Content-type";

    private static String encodeBase64(byte[] buf) {
        return Base64.getEncoder().encodeToString(buf);
    }

    public static String makeAcceptKey(String key) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        String text = key + WEBSOCKET_KEY_MAGIC;
        md.update(text.getBytes(), 0, text.length());
        byte[] sha1hash = md.digest();
        return Util.encodeBase64(sha1hash);
    }

    public static void sendResponseHeaders(HttpExchange exchange, int code, String reason) throws IOException {
        byte[] bytes = reason.getBytes();
        exchange.getRequestHeaders().set(CONTENT_TYPE, "text/plain");
        exchange.sendResponseHeaders(code, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.getRequestBody().close();
    }
}

