/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.io.IOException;
import java.io.InputStream;
import robaho.net.httpserver.ExchangeImpl;
import robaho.net.httpserver.LeftOverInputStream;

class FixedLengthInputStream
extends LeftOverInputStream {
    private long remaining;

    FixedLengthInputStream(ExchangeImpl t, InputStream src, long len) {
        super(t, src);
        if (len < 0L) {
            throw new IllegalArgumentException("Content-Length: " + len);
        }
        this.remaining = len;
    }

    @Override
    protected int readImpl(byte[] b, int off, int len) throws IOException {
        int n;
        boolean bl = this.eof = this.remaining == 0L;
        if (this.eof) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        if ((n = this.in.read(b, off, len)) > -1) {
            this.remaining -= (long)n;
        }
        if (n < 0 && !this.eof) {
            throw new IOException("connection closed before all data received");
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        int n = this.in.available();
        return (long)n < this.remaining ? n : (int)this.remaining;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int l) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

