/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

public class Utils {
    private static final boolean[] TCHAR;
    private static final boolean[] QDTEXT;
    private static final boolean[] QUOTED_PAIR;

    public static boolean isValidName(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c <= '\u00ff' && TCHAR[c]) continue;
            return false;
        }
        return !token.isEmpty();
    }

    public static boolean isQuotedStringContent(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c > '\u00ff') {
                return false;
            }
            if (!(c == '\\' ? i == token.length() - 1 || !QUOTED_PAIR[token.charAt(i++)] : !QDTEXT[c])) continue;
            return false;
        }
        return true;
    }

    static {
        int c;
        char[] allowedTokenChars;
        TCHAR = new boolean[256];
        QDTEXT = new boolean[256];
        QUOTED_PAIR = new boolean[256];
        for (char c2 : allowedTokenChars = "!#$%&'*+-.^_`|~0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            Utils.TCHAR[c2] = true;
        }
        for (c = 32; c <= 255; c = (int)((char)(c + 1))) {
            Utils.QDTEXT[c] = true;
        }
        Utils.QDTEXT[34] = false;
        Utils.QDTEXT[92] = false;
        Utils.QDTEXT[127] = false;
        for (c = 32; c <= 255; c = (int)((char)(c + 1))) {
            Utils.QUOTED_PAIR[c] = true;
        }
        Utils.QUOTED_PAIR[9] = true;
        Utils.QUOTED_PAIR[127] = false;
    }
}

