/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

class SSLConfigurator {
    SSLConfigurator() {
    }

    static void configure(SSLSocket s, HttpsConfigurator cfg) {
        s.setUseClientMode(false);
        if (cfg == null) {
            return;
        }
        InetSocketAddress remoteAddress = (InetSocketAddress)s.getRemoteSocketAddress();
        Parameters params = new Parameters(cfg, remoteAddress);
        cfg.configure(params);
        SSLParameters sslParams = params.getSSLParameters();
        if (sslParams != null) {
            s.setSSLParameters(sslParams);
        }
    }

    static class Parameters
    extends HttpsParameters {
        InetSocketAddress addr;
        HttpsConfigurator cfg;
        SSLParameters params;

        Parameters(HttpsConfigurator cfg, InetSocketAddress addr) {
            this.addr = addr;
            this.cfg = cfg;
        }

        @Override
        public InetSocketAddress getClientAddress() {
            return this.addr;
        }

        @Override
        public HttpsConfigurator getHttpsConfigurator() {
            return this.cfg;
        }

        @Override
        public void setSSLParameters(SSLParameters p) {
            this.params = p;
        }

        SSLParameters getSSLParameters() {
            return this.params;
        }
    }
}

