/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import robaho.net.httpserver.OpenAddressMap;

public class BloomSet {
    private final int bloomHash;
    private OpenAddressMap<String, Boolean> values;

    private BloomSet(String ... values) {
        this.values = new OpenAddressMap(values.length * 2);
        int bloomHash = 0;
        for (String v : values) {
            bloomHash |= v.hashCode();
            this.values.put(v, true);
        }
        this.bloomHash = bloomHash;
    }

    public static BloomSet of(String ... values) {
        return new BloomSet(values);
    }

    public boolean contains(String value) {
        return (this.bloomHash & value.hashCode()) == value.hashCode() && Boolean.TRUE.equals(this.values.get(value));
    }

    public Iterable<String> values() {
        return this.values.keys();
    }
}

