/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import robaho.net.httpserver.ExchangeImpl;
import robaho.net.httpserver.LeftOverInputStream;
import robaho.net.httpserver.StreamClosedException;

class FixedLengthOutputStream
extends FilterOutputStream {
    private long remaining;
    private boolean closed = false;
    ExchangeImpl t;

    FixedLengthOutputStream(ExchangeImpl t, OutputStream src, long len) {
        super(src);
        if (len < 0L) {
            throw new IllegalArgumentException("Content-length: " + len);
        }
        this.t = t;
        this.remaining = len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (this.remaining == 0L) {
            throw new StreamClosedException();
        }
        this.out.write(b);
        --this.remaining;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return;
        }
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if ((long)len > this.remaining) {
            throw new IOException("too many bytes to write to stream");
        }
        this.out.write(b, off, len);
        this.remaining -= (long)len;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.remaining > 0L) {
            this.t.close();
            throw new IOException("insufficient bytes written to stream");
        }
        LeftOverInputStream is = this.t.getOriginalInputStream();
        if (!is.isClosed()) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (is.getRawInputStream().available() == 0) {
            this.flush();
        }
    }
}

