/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.extras;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FormParser {
    private static final int MAX_PARAMS = Integer.getInteger("robaho.net.httpserver.max_form_params", 1000);

    public static Map<String, List<String>> parse(String encoding, InputStream is) throws IOException {
        List values;
        int bytesRead;
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        LinkedHashMap<String, List> params = new LinkedHashMap<String, List>();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) > 0) {
            os.write(buffer, 0, bytesRead);
        }
        String data = new String(os.toByteArray(), encoding);
        if (data.length() == 0) {
            return new HashMap<String, List<String>>(0);
        }
        String[] keyValues = data.split("&");
        if (MAX_PARAMS != 0 && keyValues.length > MAX_PARAMS) {
            throw new IllegalStateException("number of request parameters %d is higher than maximum of %d, aborting. Can be configured using 'http.maxParams'".formatted(keyValues.length, MAX_PARAMS));
        }
        for (String keyValue : keyValues) {
            String[] segs = keyValue.split("=", 2);
            String key = segs[0];
            String value = segs.length > 1 ? segs[1] : null;
            values = params.computeIfAbsent(key, k -> new ArrayList());
            if (value == null) continue;
            values.add(value);
        }
        if (params.containsKey("_charset_")) {
            encoding = (String)((List)params.get("_charset_")).get(0);
        }
        LinkedHashMap<String, List<String>> decodedParams = new LinkedHashMap<String, List<String>>(params.size());
        for (Map.Entry e : params.entrySet()) {
            String key = (String)e.getKey();
            key = URLDecoder.decode((String)e.getKey(), encoding);
            for (String value : (List)e.getValue()) {
                String decodedValue = value == null ? null : URLDecoder.decode(value, encoding);
                values = decodedParams.computeIfAbsent(key, k -> new ArrayList());
                if (decodedValue == null) continue;
                values.add(decodedValue);
            }
        }
        return decodedParams;
    }
}

