/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.frame;

import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.frame.FrameType;

public enum FrameFlag {
    END_STREAM(1),
    ACK(1),
    END_HEADERS(4),
    PADDED(8),
    PRIORITY(32);

    private final byte value;
    private static final byte MASK;
    private static final FrameFlag[] _values;
    public static final FlagSet NONE;

    private FrameFlag(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static FlagSet getEnumSet(byte value, FrameType type) throws HTTP2Exception {
        if (value == 0) {
            return NONE;
        }
        return new FlagSet(value & MASK, type == FrameType.SETTINGS || type == FrameType.PING);
    }

    static {
        MASK = (byte)(FrameFlag.END_STREAM.value | FrameFlag.END_HEADERS.value | FrameFlag.PADDED.value | FrameFlag.PRIORITY.value);
        _values = FrameFlag.values();
        NONE = new FlagSet(0, false);
    }

    public static class FlagSet {
        private final int value;
        private final boolean isAck;

        FlagSet(int value, boolean isAck) {
            this.value = value;
            this.isAck = isAck;
        }

        public byte value() {
            return (byte)this.value;
        }

        public boolean contains(FrameFlag flag) {
            return (this.value & flag.value) == flag.value;
        }

        public static FlagSet of(FrameFlag ... flags) {
            int value = 0;
            boolean isAck = false;
            for (FrameFlag flag : flags) {
                value |= flag.value;
                if (flag != ACK) continue;
                isAck = true;
            }
            return new FlagSet(value, isAck);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            int tmp = this.value;
            if ((tmp & 1) == 1) {
                sb.append(this.isAck ? "ACK" : "END_STREAM");
                tmp = (byte)(tmp ^ 1);
            }
            for (FrameFlag flag : _values) {
                if ((tmp & flag.value) != flag.value) continue;
                if (!sb.isEmpty()) {
                    sb.append(",");
                }
                sb.append((Object)flag);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

