/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.frame;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import robaho.net.httpserver.http2.HTTP2ErrorCode;
import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.frame.BaseFrame;
import robaho.net.httpserver.http2.frame.FrameFlag;
import robaho.net.httpserver.http2.frame.FrameHeader;
import robaho.net.httpserver.http2.frame.FrameType;
import robaho.net.httpserver.http2.frame.SettingParameter;

public class SettingsFrame
extends BaseFrame {
    ArrayList<SettingParameter> params = new ArrayList();

    public SettingsFrame() {
        this(new FrameHeader(0, FrameType.SETTINGS, FrameFlag.FlagSet.of(FrameFlag.ACK), 0));
    }

    public SettingsFrame(FrameHeader header) {
        super(header);
    }

    public ArrayList<SettingParameter> getSettingParameters() {
        return this.params;
    }

    public static SettingsFrame parse(byte[] frameBody, FrameHeader header) throws HTTP2Exception {
        if (header.getStreamIdentifier() != 0) {
            throw new HTTP2Exception(HTTP2ErrorCode.PROTOCOL_ERROR);
        }
        if (header.getFlags().contains(FrameFlag.ACK) && header.getLength() != 0) {
            throw new HTTP2Exception(HTTP2ErrorCode.FRAME_SIZE_ERROR);
        }
        if (frameBody.length % 6 != 0) {
            throw new HTTP2Exception(HTTP2ErrorCode.FRAME_SIZE_ERROR);
        }
        SettingsFrame result = new SettingsFrame(header);
        for (int paramIndex = 0; paramIndex < frameBody.length; paramIndex += 6) {
            SettingParameter param = SettingParameter.parse(Arrays.copyOfRange(frameBody, paramIndex, paramIndex + 6));
            if (param == null) continue;
            result.params.add(param);
        }
        return result;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        int settingBodySize = this.params.size() * 6;
        FrameHeader header = new FrameHeader(settingBodySize, FrameType.SETTINGS, this.getHeader().getFlags(), this.getHeader().getStreamIdentifier());
        header.writeTo(os);
        for (int i = 0; i < this.params.size(); ++i) {
            this.params.get(i).writeTo(os);
        }
    }

    @Override
    public byte[] encode() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.writeTo(bos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }
}

