/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.hpack;

import java.util.Arrays;
import java.util.Map;
import robaho.net.httpserver.OpenAddressMap;
import robaho.net.httpserver.http2.hpack.HTTP2HeaderField;

class RFC7541Parser {
    private static final HTTP2HeaderField[] STATIC_HEADER_TABLE = new HTTP2HeaderField[62];
    static final Map<String, byte[]> STATUSES = Map.of("200", RFC7541Parser.indexedField(8), "204", RFC7541Parser.indexedField(9), "206", RFC7541Parser.indexedField(10), "304", RFC7541Parser.indexedField(11), "400", RFC7541Parser.indexedField(12), "404", RFC7541Parser.indexedField(13), "500", RFC7541Parser.indexedField(13));
    private static final OpenAddressMap<String, Integer> STATIC_HEADER_NAME_TO_INDEX;

    RFC7541Parser() {
    }

    private static byte[] indexedField(int index) {
        byte[] buffer = new byte[]{(byte)(0x80 | index)};
        return buffer;
    }

    public static Integer getIndex(String name) {
        return STATIC_HEADER_NAME_TO_INDEX.get(name);
    }

    public static HTTP2HeaderField getHeaderField(int index) {
        if (index < 1 || index >= STATIC_HEADER_TABLE.length) {
            return null;
        }
        return STATIC_HEADER_TABLE[index];
    }

    public static String getHeaderFieldName(int index) {
        HTTP2HeaderField field = RFC7541Parser.getHeaderField(index);
        return field == null ? null : field.getName();
    }

    static {
        RFC7541Parser.STATIC_HEADER_TABLE[1] = new HTTP2HeaderField(":authority", null);
        RFC7541Parser.STATIC_HEADER_TABLE[2] = new HTTP2HeaderField(":method", "GET");
        RFC7541Parser.STATIC_HEADER_TABLE[3] = new HTTP2HeaderField(":method", "POST");
        RFC7541Parser.STATIC_HEADER_TABLE[4] = new HTTP2HeaderField(":path", "/");
        RFC7541Parser.STATIC_HEADER_TABLE[5] = new HTTP2HeaderField(":path", "/index.html");
        RFC7541Parser.STATIC_HEADER_TABLE[6] = new HTTP2HeaderField(":scheme", "http");
        RFC7541Parser.STATIC_HEADER_TABLE[7] = new HTTP2HeaderField(":scheme", "https");
        RFC7541Parser.STATIC_HEADER_TABLE[8] = new HTTP2HeaderField(":status", "200");
        RFC7541Parser.STATIC_HEADER_TABLE[9] = new HTTP2HeaderField(":status", "204");
        RFC7541Parser.STATIC_HEADER_TABLE[10] = new HTTP2HeaderField(":status", "206");
        RFC7541Parser.STATIC_HEADER_TABLE[11] = new HTTP2HeaderField(":status", "304");
        RFC7541Parser.STATIC_HEADER_TABLE[12] = new HTTP2HeaderField(":status", "400");
        RFC7541Parser.STATIC_HEADER_TABLE[13] = new HTTP2HeaderField(":status", "404");
        RFC7541Parser.STATIC_HEADER_TABLE[14] = new HTTP2HeaderField(":status", "500");
        RFC7541Parser.STATIC_HEADER_TABLE[15] = new HTTP2HeaderField("accept-charset", null);
        RFC7541Parser.STATIC_HEADER_TABLE[16] = new HTTP2HeaderField("accept-encoding", "gzip, deflate");
        RFC7541Parser.STATIC_HEADER_TABLE[17] = new HTTP2HeaderField("accept-language", null);
        RFC7541Parser.STATIC_HEADER_TABLE[18] = new HTTP2HeaderField("accept-ranges", null);
        RFC7541Parser.STATIC_HEADER_TABLE[19] = new HTTP2HeaderField("accept", null);
        RFC7541Parser.STATIC_HEADER_TABLE[20] = new HTTP2HeaderField("access-control-allow-origin", null);
        RFC7541Parser.STATIC_HEADER_TABLE[21] = new HTTP2HeaderField("age", null);
        RFC7541Parser.STATIC_HEADER_TABLE[22] = new HTTP2HeaderField("allow", null);
        RFC7541Parser.STATIC_HEADER_TABLE[23] = new HTTP2HeaderField("authorization", null);
        RFC7541Parser.STATIC_HEADER_TABLE[24] = new HTTP2HeaderField("cache-control", null);
        RFC7541Parser.STATIC_HEADER_TABLE[25] = new HTTP2HeaderField("content-disposition", null);
        RFC7541Parser.STATIC_HEADER_TABLE[26] = new HTTP2HeaderField("content-encoding", null);
        RFC7541Parser.STATIC_HEADER_TABLE[27] = new HTTP2HeaderField("content-language", null);
        RFC7541Parser.STATIC_HEADER_TABLE[28] = new HTTP2HeaderField("content-length", null);
        RFC7541Parser.STATIC_HEADER_TABLE[29] = new HTTP2HeaderField("content-location", null);
        RFC7541Parser.STATIC_HEADER_TABLE[30] = new HTTP2HeaderField("content-range", null);
        RFC7541Parser.STATIC_HEADER_TABLE[31] = new HTTP2HeaderField("content-type", null);
        RFC7541Parser.STATIC_HEADER_TABLE[32] = new HTTP2HeaderField("cookie", null);
        RFC7541Parser.STATIC_HEADER_TABLE[33] = new HTTP2HeaderField("date", null);
        RFC7541Parser.STATIC_HEADER_TABLE[34] = new HTTP2HeaderField("etag", null);
        RFC7541Parser.STATIC_HEADER_TABLE[35] = new HTTP2HeaderField("expect", null);
        RFC7541Parser.STATIC_HEADER_TABLE[36] = new HTTP2HeaderField("expires", null);
        RFC7541Parser.STATIC_HEADER_TABLE[37] = new HTTP2HeaderField("from", null);
        RFC7541Parser.STATIC_HEADER_TABLE[38] = new HTTP2HeaderField("host", null);
        RFC7541Parser.STATIC_HEADER_TABLE[39] = new HTTP2HeaderField("if-match", null);
        RFC7541Parser.STATIC_HEADER_TABLE[40] = new HTTP2HeaderField("if-modified-since", null);
        RFC7541Parser.STATIC_HEADER_TABLE[41] = new HTTP2HeaderField("if-none-match", null);
        RFC7541Parser.STATIC_HEADER_TABLE[42] = new HTTP2HeaderField("if-range", null);
        RFC7541Parser.STATIC_HEADER_TABLE[43] = new HTTP2HeaderField("if-unmodified-since", null);
        RFC7541Parser.STATIC_HEADER_TABLE[44] = new HTTP2HeaderField("last-modified", null);
        RFC7541Parser.STATIC_HEADER_TABLE[45] = new HTTP2HeaderField("link", null);
        RFC7541Parser.STATIC_HEADER_TABLE[46] = new HTTP2HeaderField("location", null);
        RFC7541Parser.STATIC_HEADER_TABLE[47] = new HTTP2HeaderField("max-forwards", null);
        RFC7541Parser.STATIC_HEADER_TABLE[48] = new HTTP2HeaderField("proxy-authenticate", null);
        RFC7541Parser.STATIC_HEADER_TABLE[49] = new HTTP2HeaderField("proxy-authorization", null);
        RFC7541Parser.STATIC_HEADER_TABLE[50] = new HTTP2HeaderField("range", null);
        RFC7541Parser.STATIC_HEADER_TABLE[51] = new HTTP2HeaderField("referer", null);
        RFC7541Parser.STATIC_HEADER_TABLE[52] = new HTTP2HeaderField("refresh", null);
        RFC7541Parser.STATIC_HEADER_TABLE[53] = new HTTP2HeaderField("retry-after", null);
        RFC7541Parser.STATIC_HEADER_TABLE[54] = new HTTP2HeaderField("server", null);
        RFC7541Parser.STATIC_HEADER_TABLE[55] = new HTTP2HeaderField("set-cookie", null);
        RFC7541Parser.STATIC_HEADER_TABLE[56] = new HTTP2HeaderField("strict-transport-security", null);
        RFC7541Parser.STATIC_HEADER_TABLE[57] = new HTTP2HeaderField("transfer-encoding", null);
        RFC7541Parser.STATIC_HEADER_TABLE[58] = new HTTP2HeaderField("user-agent", null);
        RFC7541Parser.STATIC_HEADER_TABLE[59] = new HTTP2HeaderField("vary", null);
        RFC7541Parser.STATIC_HEADER_TABLE[60] = new HTTP2HeaderField("via", null);
        RFC7541Parser.STATIC_HEADER_TABLE[61] = new HTTP2HeaderField("www-authenticate", null);
        STATIC_HEADER_NAME_TO_INDEX = new OpenAddressMap(256);
        Arrays.stream(STATIC_HEADER_TABLE).filter(v -> v != null).forEach(v -> STATIC_HEADER_NAME_TO_INDEX.put(v.name, Arrays.asList(STATIC_HEADER_TABLE).indexOf(v)));
    }
}

