/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import com.sun.net.httpserver.Headers;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import robaho.net.httpserver.OpenAddressMap;

public class OptimizedHeaders
extends Headers {
    private final OpenAddressMap<String, Object> map;

    public OptimizedHeaders() {
        this.map = new OpenAddressMap(16);
    }

    public OptimizedHeaders(int capacity) {
        this.map = new OpenAddressMap(capacity);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    public List<String> get(Object key) {
        List<String> list;
        Object o = this.map.get(OptimizedHeaders.normalize((String)key));
        if (o == null) {
            list = null;
        } else if (o instanceof String) {
            String s = (String)o;
            list = List.of(s);
        } else {
            list = (List<String>)o;
        }
        return list;
    }

    @Override
    public List<String> put(String key, List<String> value) {
        List<String> list;
        List<String> o = this.map.put(OptimizedHeaders.normalize(key), value);
        if (o == null) {
            list = null;
        } else if (o instanceof String) {
            String s = (String)((Object)o);
            list = List.of(s);
        } else {
            list = o;
        }
        return list;
    }

    @Override
    public List<String> remove(Object key) {
        List<String> list;
        Object o = this.map.put(OptimizedHeaders.normalize((String)key), null);
        if (o == null) {
            list = null;
        } else if (o instanceof String) {
            String s = o;
            list = List.of(s);
        } else {
            list = o;
        }
        return list;
    }

    @Override
    public String getFirst(String key) {
        String s;
        Object o = this.map.get(OptimizedHeaders.normalize(key));
        return o == null ? null : (o instanceof String ? (s = (String)o) : (String)((List)o).getFirst());
    }

    private static String normalize(String key) {
        int i;
        int len = key.length();
        if (len == 0) {
            return key;
        }
        for (i = 0; i < len; ++i) {
            char c = key.charAt(i);
            if (c == '\r' || c == '\n') {
                throw new IllegalArgumentException("illegal character in key");
            }
            if (i == 0 ? c >= 'a' && c <= 'z' : c >= 'A' && c <= 'Z') break;
        }
        if (i == len) {
            return key;
        }
        return Character.toUpperCase(key.charAt(0)) + key.substring(1).toLowerCase();
    }

    @Override
    public void add(String key, String value) {
        String normalized = OptimizedHeaders.normalize(key);
        Object o = this.map.get(normalized);
        if (o == null) {
            this.map.put(normalized, value);
        } else if (o instanceof String) {
            String s = (String)o;
            this.map.put(normalized, new ArrayList<String>(List.of(s, value)));
        } else {
            ((List)o).add(value);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void set(String key, String value) {
        this.map.put(OptimizedHeaders.normalize(key), value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.get(OptimizedHeaders.normalize((String)key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.entrySet().stream().anyMatch(e -> ((List)e.getValue()).contains((String)value));
    }

    @Override
    public Set<String> keySet() {
        return this.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toSet());
    }

    @Override
    public Collection<List<String>> values() {
        return this.entrySet().stream().map(e -> (List)e.getValue()).collect(Collectors.toSet());
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        HashSet<Map.Entry<String, List<String>>> set = new HashSet<Map.Entry<String, List<String>>>();
        this.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(k, v) -> set.add(new AbstractMap.SimpleEntry<String, List>((String)k, (List)v))));
        return set;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super List<String>> action) {
        this.map.forEach((K k, V v) -> {
            List<String> list;
            if (v instanceof String) {
                String s = (String)v;
                list = List.of(s);
            } else {
                list = (List<String>)v;
            }
            action.accept((String)k, (List<String>)list);
        });
    }
}

