/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import robaho.net.httpserver.ExchangeImpl;
import robaho.net.httpserver.LeftOverInputStream;

class UndefLengthOutputStream
extends FilterOutputStream {
    private boolean closed = false;
    ExchangeImpl t;

    UndefLengthOutputStream(ExchangeImpl t, OutputStream src) {
        super(src);
        this.t = t;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return;
        }
        if (this.closed) {
            throw new IOException("stream closed");
        }
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flush();
        LeftOverInputStream is = this.t.getOriginalInputStream();
        if (is != null && !is.isClosed()) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

