/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.http2.frame;

import java.io.InputStream;
import robaho.net.httpserver.ServerConfig;
import robaho.net.httpserver.http2.HTTP2Connection;
import robaho.net.httpserver.http2.HTTP2ErrorCode;
import robaho.net.httpserver.http2.HTTP2Exception;
import robaho.net.httpserver.http2.frame.BaseFrame;
import robaho.net.httpserver.http2.frame.ContinuationFrame;
import robaho.net.httpserver.http2.frame.DataFrame;
import robaho.net.httpserver.http2.frame.FrameHeader;
import robaho.net.httpserver.http2.frame.FrameType;
import robaho.net.httpserver.http2.frame.GoawayFrame;
import robaho.net.httpserver.http2.frame.HeadersFrame;
import robaho.net.httpserver.http2.frame.NotImplementedFrame;
import robaho.net.httpserver.http2.frame.PingFrame;
import robaho.net.httpserver.http2.frame.PriorityFrame;
import robaho.net.httpserver.http2.frame.PushPromiseFrame;
import robaho.net.httpserver.http2.frame.ResetStreamFrame;
import robaho.net.httpserver.http2.frame.SettingsFrame;
import robaho.net.httpserver.http2.frame.WindowUpdateFrame;

public class FrameSerializer {
    public static BaseFrame deserialize(InputStream inputStream) throws Exception {
        byte[] tmpBuffer = new byte[9];
        HTTP2Connection.readFully(inputStream, tmpBuffer);
        FrameHeader frameHeader = FrameHeader.Parse(tmpBuffer);
        if (frameHeader.getLength() > ServerConfig.http2MaxFrameSize()) {
            throw new HTTP2Exception(HTTP2ErrorCode.FRAME_SIZE_ERROR);
        }
        byte[] body = new byte[frameHeader.getLength()];
        HTTP2Connection.readFully(inputStream, body);
        return switch (frameHeader.getType()) {
            case FrameType.HEADERS -> HeadersFrame.parse(body, frameHeader);
            case FrameType.CONTINUATION -> ContinuationFrame.parse(body, frameHeader);
            case FrameType.DATA -> DataFrame.parse(body, frameHeader);
            case FrameType.GOAWAY -> GoawayFrame.parse(body, frameHeader);
            case FrameType.PING -> PingFrame.parse(body, frameHeader);
            case FrameType.PRIORITY -> PriorityFrame.parse(body, frameHeader);
            case FrameType.PUSH_PROMISE -> PushPromiseFrame.parse(body, frameHeader);
            case FrameType.RST_STREAM -> ResetStreamFrame.parse(body, frameHeader);
            case FrameType.SETTINGS -> SettingsFrame.parse(body, frameHeader);
            case FrameType.WINDOW_UPDATE -> WindowUpdateFrame.parse(body, frameHeader);
            default -> NotImplementedFrame.parse(body, frameHeader);
        };
    }
}

