/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiConsumer;

public class OpenAddressMap<K, V> {
    private int capacity;
    private int mask;
    private int size;
    private int used;
    private Entry[] entries;

    private static int hash(int hash) {
        return hash;
    }

    public OpenAddressMap(int capacity) {
        --capacity;
        capacity |= capacity >> 1;
        capacity |= capacity >> 2;
        capacity |= capacity >> 4;
        capacity |= capacity >> 8;
        capacity |= capacity >> 16;
        this.capacity = ++capacity;
        this.mask = capacity - 1;
        this.entries = new Entry[capacity];
    }

    public V put(K key, V value) {
        Entry entry;
        int index;
        if (this.used >= this.capacity / 2) {
            this.resize();
        }
        int start = index = OpenAddressMap.hash(key.hashCode()) & this.mask;
        int sentinel = -1;
        while ((entry = this.entries[index]) != null) {
            if (entry.key.equals(key)) {
                Object oldValue = entry.value;
                entry.value = value;
                if (value == null) {
                    --this.size;
                }
                return oldValue;
            }
            if (entry.value == null) {
                sentinel = index;
            }
            if ((index = index + 1 & this.mask) != start) continue;
            this.resize();
            start = index = OpenAddressMap.hash(key.hashCode()) & this.mask;
        }
        this.entries[sentinel == -1 ? index : sentinel] = new Entry<K, V>(key, value);
        ++this.size;
        if (sentinel != -1) {
            ++this.used;
        }
        return null;
    }

    private void resize() {
        OpenAddressMap newMap = new OpenAddressMap(this.capacity << 1);
        for (Entry entry : this.entries) {
            if (entry == null) continue;
            newMap.put(entry.key, entry.value);
        }
        this.entries = newMap.entries;
        this.capacity = newMap.capacity;
        this.mask = newMap.mask;
        this.size = newMap.size;
        this.used = newMap.used;
    }

    public V get(K key) {
        Entry entry;
        int index;
        int start = index = OpenAddressMap.hash(key.hashCode()) & this.mask;
        while ((entry = this.entries[index]) != null) {
            if (entry.key.equals(key)) {
                return entry.value;
            }
            if ((index = index + 1 & this.mask) != start) continue;
            break;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.entries, null);
        this.size = 0;
        this.used = 0;
    }

    public void forEach(BiConsumer<K, V> action) {
        for (Entry entry : this.entries) {
            if (entry == null || entry.value == null) continue;
            action.accept(entry.key, entry.value);
        }
    }

    public Iterable<K> keys() {
        return () -> new KeyIterator();
    }

    private static class Entry<K, V> {
        K key;
        V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }

    private class KeyIterator
    implements Iterator<K> {
        private int index = 0;

        private KeyIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < OpenAddressMap.this.entries.length) {
                if (OpenAddressMap.this.entries[this.index] != null && OpenAddressMap.this.entries[this.index].value != null) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public K next() {
            return OpenAddressMap.this.entries[this.index++].key;
        }
    }
}

