/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.util.concurrent.atomic.AtomicLong;

class ServerStats {
    final AtomicLong connectionCount = new AtomicLong();
    final AtomicLong requestCount = new AtomicLong();
    final AtomicLong handleExceptionCount = new AtomicLong();
    final AtomicLong socketExceptionCount = new AtomicLong();
    final AtomicLong idleCloseCount = new AtomicLong();
    final AtomicLong replyErrorCount = new AtomicLong();
    final AtomicLong maxConnectionsExceededCount = new AtomicLong();
    private volatile long lastStatsTime = System.currentTimeMillis();

    ServerStats() {
    }

    public String stats() {
        long now = System.currentTimeMillis();
        double secs = (double)(now - this.lastStatsTime) / 1000.0;
        this.lastStatsTime = now;
        long _requests = this.requestCount.getAndSet(0L);
        return "Connections Since: " + this.connectionCount.getAndSet(0L) + "\nRequests Since: " + _requests + "\nRequests/sec: " + (long)((double)_requests / secs) + "\nTotal Handler Exceptions: " + this.handleExceptionCount.get() + "\nTotal Socket Exceptions: " + this.socketExceptionCount.get() + "\nTotal Max Connections Exceeded: " + this.maxConnectionsExceededCount.get() + "\nTotal Idle Closes: " + this.idleCloseCount.get() + "\nTotal Reply Errors: " + this.replyErrorCount.get() + "\n";
    }
}

