/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.extras;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import robaho.net.httpserver.NoSyncBufferedOutputStream;

public class MultipartFormParser {
    static final Logger logger = Logger.getLogger("robaho.net.httpserver.MultipartFormParser");
    private static final Pattern optionPattern = Pattern.compile("\\s(?<key>.*)=\"(?<value>.*)\"");

    public static Map<String, List<Part>> parse(String encoding, String content_type, InputStream is, Path storage) throws IOException {
        Charset charset;
        Charset charset2 = charset = encoding == null ? StandardCharsets.ISO_8859_1 : Charset.forName(encoding);
        if (!content_type.contains("boundary=")) {
            throw new IllegalStateException("content type does not contain boundary");
        }
        String boundary = content_type.split("boundary=")[1];
        is = new BufferedInputStream(is);
        HashMap<String, List<Part>> results = new HashMap<String, List<Part>>();
        byte[] boundaryCheck = ("\r\n--" + boundary).getBytes(charset);
        LinkedList<String> headers = new LinkedList<String>();
        logger.finer(() -> "reading multipart form data with boundary '%s'".formatted(boundary));
        int matchCount = 2;
        while (true) {
            int c;
            if ((c = is.read()) == -1) {
                return results;
            }
            if (c == boundaryCheck[matchCount]) {
                if (++matchCount != boundaryCheck.length - 2) continue;
                break;
            }
            matchCount = 0;
            if (c != boundaryCheck[matchCount]) continue;
            ++matchCount;
        }
        String s = MultipartFormParser.readLine(charset, is);
        if (s == null || "--".equals(s)) {
            return results;
        }
        headers.clear();
        while (true) {
            Runnable addToResults;
            OutputStream os;
            if ((s = MultipartFormParser.readLine(charset, is)) == null) {
                return results;
            }
            if (!"".equals(s)) {
                headers.add(s);
                continue;
            }
            PartMetadata meta = MultipartFormParser.parseHeaders(headers);
            if (meta.filename == null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                os = bos;
                addToResults = () -> results.computeIfAbsent(meta.name, k -> new LinkedList()).add(new Part(meta.contentType, null, bos.toString(charset), null));
            } else {
                File file = Path.of(storage.toString(), meta.filename).toFile();
                file.deleteOnExit();
                os = new NoSyncBufferedOutputStream(new FileOutputStream(file));
                addToResults = () -> results.computeIfAbsent(meta.name, k -> new LinkedList()).add(new Part(meta.contentType, meta.filename, null, file));
            }
            try (ByteArrayOutputStream byteArrayOutputStream = os;){
                matchCount = 0;
                while (true) {
                    int c;
                    if ((c = is.read()) == -1) {
                        HashMap<String, List<Part>> hashMap = results;
                        return hashMap;
                    }
                    if (c == boundaryCheck[matchCount]) {
                        if (++matchCount != boundaryCheck.length) continue;
                        break;
                    }
                    if (matchCount > 0) {
                        os.write(boundaryCheck, 0, matchCount);
                        matchCount = 0;
                    }
                    if (c == boundaryCheck[matchCount]) {
                        ++matchCount;
                        continue;
                    }
                    os.write(c);
                }
            }
            addToResults.run();
            s = MultipartFormParser.readLine(charset, is);
            if ("--".equals(s)) break;
        }
        return results;
    }

    private static PartMetadata parseHeaders(List<String> headers) {
        String name = null;
        String filename = null;
        String contentType = null;
        for (String header : headers) {
            String[] parts = header.split(":", 2);
            if ("content-disposition".equalsIgnoreCase(parts[0])) {
                String[] options;
                for (String option : options = parts[1].split(";")) {
                    Matcher m = optionPattern.matcher(option);
                    if (!m.matches()) continue;
                    String key = m.group("key");
                    String value = m.group("value");
                    if ("name".equals(key)) {
                        name = value;
                    }
                    if (!"filename".equals(key)) continue;
                    filename = value;
                }
                continue;
            }
            if (!"content-type".equalsIgnoreCase(parts[0])) continue;
            contentType = parts[1].trim();
        }
        return new PartMetadata(contentType, name, filename);
    }

    private static String readLine(Charset charset, InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean prevCR = false;
        while (true) {
            int c;
            if ((c = is.read()) == -1) {
                if (bos.size() > 0) {
                    return bos.toString(charset);
                }
                return null;
            }
            if (c == 13) {
                prevCR = true;
                continue;
            }
            if (c == 10) {
                if (prevCR) {
                    return bos.toString(charset);
                }
                bos.write(c);
                continue;
            }
            if (prevCR) {
                bos.write(13);
                prevCR = false;
            }
            bos.write(c);
        }
    }

    private record PartMetadata(String contentType, String name, String filename) {
    }

    public record Part(String contentType, String filename, String data, File file) {
    }
}

