/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import robaho.net.httpserver.HttpContextImpl;

class HttpConnection {
    private static final System.Logger logger = System.getLogger("robaho.net.httpserver");
    HttpContextImpl context;
    InputStream is;
    OutputStream os;
    final Socket socket;
    volatile boolean closed = false;
    volatile long lastActivityTime;
    volatile boolean noActivity;
    volatile boolean inRequest;

    SSLSession getSSLSession() {
        SSLSession sSLSession;
        Socket socket = this.socket;
        if (socket instanceof SSLSocket) {
            SSLSocket ssl = (SSLSocket)socket;
            sSLSession = ssl.getHandshakeSession();
        } else {
            sSLSession = null;
        }
        return sSLSession;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(HttpConnection.class.getSimpleName());
        if (this.socket != null) {
            sb.append(" (");
            sb.append(this.socket);
            sb.append(")");
        }
        return sb.toString();
    }

    HttpConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.is = new BufferedInputStream(new ActivityTimerInputStream(socket.getInputStream()));
        this.os = new BufferedOutputStream(new ActivityTimerOutputStream(socket.getOutputStream()));
    }

    void setContext(HttpContextImpl ctx) {
        this.context = ctx;
    }

    Socket getSocket() {
        return this.socket;
    }

    synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.socket != null) {
            logger.log(System.Logger.Level.TRACE, "Closing connection: " + this.socket.toString());
        }
        if (this.socket.isClosed()) {
            return;
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.TRACE, "error closing input stream", (Throwable)e);
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.TRACE, "error closing output stream", (Throwable)e);
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.TRACE, "error closing socket", (Throwable)e);
        }
    }

    InputStream getInputStream() {
        return this.is;
    }

    OutputStream getOutputStream() {
        return this.os;
    }

    HttpContextImpl getHttpContext() {
        return this.context;
    }

    private class ActivityTimerInputStream
    extends FilterInputStream {
        private ActivityTimerInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public int read() throws IOException {
            try {
                int n = super.read();
                return n;
            }
            finally {
                HttpConnection.this.lastActivityTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            try {
                long l = super.skip(n);
                return l;
            }
            finally {
                HttpConnection.this.lastActivityTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                HttpConnection.this.lastActivityTime = System.currentTimeMillis();
            }
        }
    }

    private class ActivityTimerOutputStream
    extends FilterOutputStream {
        private ActivityTimerOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.out.write(b);
            }
            finally {
                HttpConnection.this.lastActivityTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.out.write(b, off, len);
            }
            finally {
                HttpConnection.this.lastActivityTime = System.currentTimeMillis();
            }
        }
    }
}

